<?php

namespace App\Controller\Admin;

use App\Controller\Base\AbstractInvoiceController;
use App\Electronico\Comprobante;
use App\Entity\Model\Customer;
use App\Entity\Model\Invoice;
use App\Entity\Model\Item;
use App\Entity\Model\ItemPago;
use App\Service\EmFactory;
use App\Util\Funciones;
use App\Util\RestApiFunciones;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Mobile_Detect;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Config\Definition\Exception\Exception;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Contracts\Translation\TranslatorInterface;
use Twig\NodeVisitor\MacroAutoImportNodeVisitor;

/**
 * @Route("/svadmin/re")
 */
class AdminRetencionController extends AbstractController
{

    protected $translator;

    /**
     * @Route("", name="admin_re_index")
     *
     */
    public function indexAction(EmFactory $emFactory, Request $request, PaginatorInterface $paginator, TranslatorInterface $translator): \Symfony\Component\HttpFoundation\Response
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $emisor = $empresaRepo->findOneByUser($user->getRuc());

        $repo = $em->getRepository(\App\Entity\Model\Comprobantes::class);
        $repo->setPaginator($paginator);
        // @todo Unhardcode this.
        $limit = 20;

        /*$fecha = new \DateTime();
        $fecha->modify('first day of this month');
        $desde = \DateTime::createFromFormat('d/m/Y', $fecha->format('d/m/Y'));
        $fecha->modify('last day of this month');
        $hasta = \DateTime::createFromFormat('d/m/Y', $fecha->format('d/m/Y'));

        $data = [
            'terms' => null,
            'status' => null,
            'date_from' => $desde,
            'date_to' => $hasta
        ];

        */

        $form = $this->createForm(\App\Form\SearchGenericAdminType::class, null, [
            'action' => $this->generateUrl('admin_re_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            $pagination = $repo->paginatedSearchRetenciones($form->getData(), $limit, $request->query->getInt('page', 1));
        } else {
            $pagination = $repo->paginatedSearchRetenciones([], $limit, $request->query->getInt('page', 1));
        }

        $invoices = [];
        foreach ($pagination->getItems() as $item) {
            $invoices[] = $item;
        }

        $listForm = $this->createForm(\App\Form\ListGenericType::class, $invoices, [
            'action' => $this->generateUrl('admin_re_index'),
        ]);
        $listForm->handleRequest($request);
        if ($listForm->isSubmitted() && $listForm->isValid()) {
            $data = $listForm->getData();
            if (empty($data['invoices'])) {
                $this->addTranslatedMessage('flash.nothing_selected', 'warning');
            } elseif ($request->request->has('autorizar')) {
                return $this->bulkAutorizar($data['invoices']);
            } elseif ($request->request->has('pdf')) {
                return $this->bulkPdf($data['invoices']);
            } elseif ($request->request->has('print')) {
                return $this->bulkPrint($data['invoices']);
            } elseif ($request->request->has('email')) {
                return $this->bulkEmail($data['invoices']);
            }
        }

        return $this->render('Admin\RE\index.html.twig',
            [
                'invoices' => $pagination,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
                'search_form' => $form->createView(),
                'list_form' => $listForm->createView(),
            ]);
    }


    /**
     * @Route("/show/{slug}inv{id}", name="admin_re_show")
     *
     */
    public function showAction($id, EmFactory $emFactory, $slug, TranslatorInterface $translator, Request $request, LoggerInterface $logger): \Symfony\Component\HttpFoundation\Response
    {
        $this->logger = $logger;
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $emisor = $empresaRepo->findOneByUser($user->getRuc());

        $entity = $em->getRepository(\App\Entity\Model\Invoice::class)->findBySlug($slug, $id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $defaultData = ['slug' => $slug, 'id'=>$id, 'customerEmail' => $entity->getCustomerEmail()];

        $form = $this->createFormBuilder($defaultData)
            ->add('slug', HiddenType::class)
            ->add('id', HiddenType::class)
            ->add('customerEmail')
            ->setAction($this->generateUrl('invoice_show', ['id' => $id, 'slug'=>$slug]))
            ->getForm();

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // data is an array with "name", "email", and "message" keys
            $data = $form->getData();

            if ($request->request->has('Form-pdf')) {
                $this->generarPdf($entity);
            } elseif ($request->request->has('Form-email')) {
                if (isset($data['customerEmail'])) {
                    $email = $data['customerEmail'];
                    $this->enviarMail($email, $entity);
                } else
                    $this->addTranslatedMessage('Email del cliente nulo o en blanco', 'warning');
            } elseif ($request->request->has('Form-edit')) {
                if ($entity->getAutorizado() === false)
                    return $this->redirectToRoute('invoice_edit', ['id' => $entity->getId(), 'slug' => $slug]);
            } elseif ($request->request->has('Form-delete')) {
                $error = $this->delete($entity);
                if ($error)
                    return $this->redirectToRoute('invoice_index');
            } elseif ($request->request->has('Form-anular')) {
                $entity->setAnulado(true);
                $em->persist($entity);
                $em->flush();
            } elseif ($request->request->has('Form-enviar')) {
                $this->enviarSriOnline($entity);
            } elseif ($request->request->has('Form-auto')) {
                if ($entity->getAutorizado() === false) {
                    $resp = $this->consultarAutorizacion($entity);
                    if ($resp != null)
                        $this->addTranslatedMessage($resp, 'danger');
                }

            }
        }

        if ($entity->getMensajeError()) {
            $this->addTranslatedMessage($entity->getMensajeError(), 'danger');
        }

        /*if (!$entity->isClosed()) {
            // When the invoice is open send to the edit form by default.
            return $this->redirect($this->generateUrl('invoice_edit', array('id' => $id)));
        }
        */

        return $this->render('Invoice\show.html.twig',
            [
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
            ]);
    }

    /**
     * @Route("/new", name="invoice_add")
     *
     */
    public function newAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator): \Symfony\Component\HttpFoundation\Response
    {
        //require_once "Mobile_Detect.php";
        $detect = new Mobile_Detect;


        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        // Check for mobile environment.
        $movil = false;
        if ($detect->isMobile()) {
            // Your code here.
            $movil = true;
        }

        $invoice = new Invoice();
        $newItem = new Item();

        $tax = $em->getRepository(\App\Entity\Model\Tax::class)->findTaxDefault($empresa->getId());
        $newItem->setTaxes($tax);
        $invoice->addItem($newItem);

        $itemPago = new ItemPago();
        $itemPago->setPlazo(0);

        $invoice->addPago($itemPago);

        /*if ($request->isMethod('GET') || $request->isMethod('get')) {
            $consfinal = $em->getRepository('App\Entity\Model\Customer')->findConsumidorFinal($empresa->getId());
            if ($consfinal) {
                //$consfinal = new Customer();
                $invoice->setCustomer($consfinal);
                $invoice->setCustomerIdentification($consfinal->getIdentification());
                $invoice->setCustomerName($consfinal->getName());
                $invoice->setInvoicingAddress($consfinal->getInvoicingAddress());
                $invoice->setCustomerEmail($consfinal->getEmail());
            }
        }*/

        $form = $this->createForm(\App\Form\InvoiceType::class, $invoice, [
            'action' => $this->generateUrl('invoice_add'),
        ]);

        /*if ($request->isMethod('POST')) {

            $taxRepo = $em->getRepository('SiwappCoreBundle:Tax');

            $all = $request->request->all();

            $aux= $all['invoice']['items'];
            if ( $aux != null) {

                foreach ($aux as $clave=>$Item) {
                    if ($Item['taxes'] == "S") {
                        $tax = $taxRepo->find(1);
                        if (!$tax) {
                            continue;
                        }
                        $Item['taxes'] = array(1);
                    } else {
                        $tax = $taxRepo->find(2);
                        if (!$tax) {
                            continue;
                        }
                        $Item['taxes'] = array(2);
                    }
                    $aux[$clave]= $Item;

                }

                $all['invoice']['items'] = $aux;
                $request->request->replace($all);
            }
            $form->handleRequest($request);
        }
        else*/

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            if ($request->request->has('save_draft')) {
                $invoice->setStatus(Invoice::DRAFT);
            } else {
                // Any save action transforms this to opened.
                $invoice->setStatus(Invoice::OPENED);
            }

            //if ($invoice->getCustomer() == null && $invoice->getCustomerIdentification() != '9999999999999') {
            //    $this->addTranslatedMessage('Cliente no se encuentra registrado', 'danger');
            //} else {
                //$invoice->setNumber(null);
                $serie = $invoice->getSeries()->getValue();
                $invoice->setSerie($serie);
                $this->cargarImpuestos($invoice);
                $invoice->setEmpresa($empresa);
                $invoice->setUsuario($user->getId());
                $invoice->setAmbiente($empresa->getTipoAmbiente());

                $em->persist($invoice);
                $em->flush();
                //$this->addTranslatedMessage('flash.added');

                $invoice_id = $invoice->getId();

                $invoice = $this->generarXml($invoice);

                if ($empresa->getEnvioAutomatico()) {

                    if ($invoice !== null) {
                        $app_url = $this->getParameter('cola_url');

                        $error = false;

                        $resp = RestApiFunciones::enviarComprobanteCola($error,
                            $invoice->getCustomerName(),
                            $invoice->getCustomerEmail(),
                            $user->getId(),
                            $invoice->getXml(),
                            $invoice->getClaveAcceso(),
                            $app_url,
                            'invoice'
                        );

                        if ($error) {
                            $this->addTranslatedMessage($resp, 'danger');
                            $invoice->setMensajeError($resp);
                        }

                        $em->persist($invoice);
                        $em->flush();

                    }

                    return $this->redirectToRoute('invoice_index');

                }

                return $this->redirectToRoute('invoice_show', ['id' => $invoice_id, 'slug' => $invoice->getSlug()]);
            //}
        }

        $customer = new Customer();

        $formcustomer = $this->createForm(\App\Form\CustomerType::class, $customer, [
            'action' => $this->generateUrl('rest_customer_add'),
        ]);
        $formcustomer->handleRequest($request);

        return $this->render('Invoice\edit.html.twig',
            [
                'form' => $form->createView(),
                'movil' => $movil,
                'formcustomer' => $formcustomer->createView(),
                'customer' => $customer,
                'entity' => $invoice,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $empresa == null ? 'USD' : $empresa->getCurrency(),
            ]);
    }


    /**
     * @Route("/edit/{slug}inv{id}", name="invoice_edit")
     *
     */
    public function editAction($id, EmFactory $emFactory, Request $request, $slug, TranslatorInterface $translator): \Symfony\Component\HttpFoundation\Response
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $entity = $em->getRepository(\App\Entity\Model\Invoice::class)->findBySlug($slug, $id);
        if (!$entity && $entity->getEmpresa() != $empresa) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        if($entity->getAutorizado()){
            return $this->redirectToRoute('invoice_show', ['id' => $id, 'slug' => $slug]);
        }

        $form = $this->createForm(\App\Form\InvoiceType::class, $entity, [
            'action' => $this->generateUrl('invoice_edit', ['id' => $id, 'slug' => $slug]),
        ]);
        $form->handleRequest($request);

        $entity->setEmpresa($empresa);

        if ($form->isSubmitted() && $form->isValid()) {
            $redirectRoute = 'invoice_show';

            $serie = $entity->getSeries()->getValue();
            $entity->setSerie($serie);
            $entity->setUsuario($user->getId());
            $this->cargarImpuestos($entity);

            if ($request->request->has('save_draft')) {
                $entity->setStatus(Invoice::DRAFT);
            } elseif ($request->request->has('save_close')) {
                $entity->setForcefullyClosed(true);
            } elseif ($entity->isDraft()) {
                // Any save action transforms this to opened.
                $entity->setStatus(Invoice::OPENED);
            }

            /*
            // See if one of PDF/Print buttons was clicked.
            if ($request->request->has('save_pdf')) {
                $redirectRoute = 'invoice_show_pdf';
            } elseif ($request->request->has('save_print')) {
                $this->get('session')->set('invoice_auto_print', $id);
            }

            */

            // Save.
            $em->persist($entity);
            $em->flush();
            //$this->addTranslatedMessage('flash.updated');

            $entity = $this->generarXml($entity);

            return $this->redirectToRoute($redirectRoute, ['id' => $id, 'slug' => $slug]);
        }

        return $this->render('Invoice\edit.html.twig',
            [
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $empresa == null ? 'USD' : $empresa->getCurrency(),
            ]);
    }

    public function enviarSriOnline(Invoice $invoice, EntityManagerInterface $entityManager)
    {
        $invoice = $this->generarXml($invoice);
        $em = $entityManager;

        if($invoice !== null) {
            $app_url = $this->getParameter('api_url');

            $error = false;
            $resp = RestApiFunciones::enviarComprobante($error, $invoice->getXml(), $invoice->getClaveAcceso(), $app_url);

            if ($error) {
                $this->addTranslatedMessage($resp->message, 'danger');
            } elseif ($resp->estado === 'recibido') {
                $resp = $this->consultarAutorizacion($invoice);
                if ($resp !== null)
                    $this->addTranslatedMessage($resp, 'danger');
            } else {
                $invoice->setMensajeError($resp->message);
                $this->addTranslatedMessage($resp->message, 'danger');
                $em->persist($invoice);
                $em->flush();
            }

        }
    }

    /**
     * @Route("/payments/{slug}inv{id}", name="invoice_payments")
     *
     */
    public function paymentsAction(Request $request, $slug, EmFactory $emFactory, TranslatorInterface $translator): \Symfony\Component\HttpFoundation\Response
    {
        $emisor = null;
        $this->translator = $translator;

        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        // Return all payments
        $invoice = $em->getRepository(\App\Entity\Model\Invoice::class)->findBySlug($slug);
        if (!$invoice) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $payment = new Payment;
        $addForm = $this->createForm(\App\Form\PaymentType::class, $payment, [
            'action' => $this->generateUrl('invoice_payments', ['id' => $invoice->getId(), 'slug' => $slug]),
        ]);
        $addForm->handleRequest($request);
        if ($addForm->isSubmitted() && $addForm->isValid()) {
            $invoice->addPayment($payment);
            $em->persist($invoice);
            $em->flush();
            $this->addTranslatedMessage('payment.flash.added');

            // Rebuild the query, since we have new objects now.
            return $this->redirectToRoute('invoice_index');
        }

        $listForm = $this->createForm('App\Form\ListInvoicePaymentType', $invoice->getPayments()->getValues(), [
            'action' => $this->generateUrl('invoice_payments', ['id' => $invoice->getId(), 'slug' => $slug]),
        ]);
        $listForm->handleRequest($request);

        if ($listForm->isSubmitted() && $listForm->isValid()) {
            $data = $listForm->getData();
            foreach ($data['payments'] as $payment) {
                $invoice->removePayment($payment);
                $em->persist($invoice);
                $em->flush();
            }

            $this->addTranslatedMessage('payment.flash.bulk_deleted');

            // Rebuild the query, since some objects are now missing.
            return $this->redirectToRoute('invoice_index');
        }

        return $this->render('Payment\list.html.twig',
            [
                'invoiceId' => $invoiceId,
                'add_form' => $addForm->createView(),
                'list_form' => $listForm->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $emisor == null ? 'USD' : $emisor->getCurrency(),
            ]);
    }

    /**
     * @Route("/form-totals", name="invoice_form_totals")
     */
    public function getInvoiceFormTotals(EmFactory $emFactory, Request $request): \Symfony\Component\HttpFoundation\Response
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $post = $request->request->get('invoice');
        if (!$post) {
            throw new NotFoundHttpException;
        }

        $response = $this->getInvoiceTotalsFromPost($post, new Invoice, $request->getLocale());

        return new JsonResponse($response);
    }

    /**
     * @Route("/pdfpreview/{slug}inv{id}", name="invoice_show_pdf_preview")
     *
     */
    public function showOnlinePdfAction($id,  $slug, EmFactory $emFactory, TranslatorInterface $translator, Request $request, LoggerInterface $logger): \Symfony\Component\HttpFoundation\Response
    {
        $this->logger = $logger;
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $invoice = $em->getRepository(\App\Entity\Model\Invoice::class)->findBySlug($slug, $id);
        if (!$invoice) {
            throw $this->createNotFoundException('Unable to find Invoice entity.');
        }

        $filename = 'FAC_' . $invoice->getSerie() . "-" . str_pad($invoice->getNumber(), 9, '0', STR_PAD_LEFT) . '.pdf';

        $xml = $invoice->getAutorizado() ? $invoice->getXmlAutorizado() : $invoice->getXml();

        $app_url = $this->getParameter('api_url').'facturaride.php';

        $error = false;
        $mensaje = "";

        $docPdf = RestApiFunciones::getPdf($error, $app_url, $invoice->getClaveAcceso(), $xml, $mensaje, null);

        if ($error) {
            $this->addTranslatedMessage('ERRROR AL GENERAR EL PDF, ' . $mensaje, 'danger');
        } else {
            file_put_contents($filename, $docPdf);

            $pdf = base64_encode(file_get_contents($filename));

            $response = new Response($pdf);
            $response->headers->set('Content-Type', 'application/octet-stream');
            $response->headers->set('Content-Description', 'File Transfer');
            $response->headers->set('Content-Disposition', 'attachment; filename="'.$filename.'"');
            // $response->headers->set('Expires', '0');
            // $response->headers->set('Content-Transfer-Encoding', 'binary');
            $response->headers->set('Content-length', strlen($pdf));
            $response->headers->set('Cache-Control', 'no-cache private');
            // $response->headers->set('Pragma', 'public');
            // Send headers before outputting anything
            $response->sendHeaders();



            try {
                unlink($filename);
            } catch (\Exception $exception) {

            }

            return $response;
        }
    }

    protected function bulkAutorizar(array $invoices, EntityManagerInterface $entityManager)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');

        $em = $entityManager;

        foreach ($invoices as $invoice) {
            if($invoice !== null) {
                $app_url = $this->getParameter('api_url');

                $error = false;
                $resp = RestApiFunciones::enviarComprobante($error, $invoice->getXml(), $invoice->getClaveAcceso(), $app_url);

                if ($error) {
                    $this->addTranslatedMessage($resp->message, 'danger');
                } elseif ($resp->estado === 'recibido') {
                    $resp = $this->consultarAutorizacion($invoice);
                    if ($resp !== null)
                        $this->addTranslatedMessage($resp, 'danger');
                } else {
                    $invoice->setMensajeError($resp->message);
                    $this->addTranslatedMessage($resp->message, 'danger');
                    $em->persist($invoice);
                    $em->flush();
                }

            }
        }

        //return $this->redirect($this->generateUrl('admin_cmp_index'));
    }

    protected function consultarAutorizacion(Invoice $invoice, EntityManagerInterface $entityManager)
    {
        $respuesta = null;
        try {
            $em = $entityManager;

            $app_url = $this->getParameter('api_url');

            $error = false;

            $resp = RestApiFunciones::consultarAutoComprobante($error, $app_url, $invoice->getClaveAcceso());

            if ($error) {
                $this->addTranslatedMessage($resp, 'danger');
                $invoice->setSinrespuesta(true);
                $invoice->setMensajeError($resp);
                $em->persist($invoice);
                $em->flush();
            } elseif ($resp->autorizado) {
                $this->addTranslatedMessage('Comprobante autorizado, fecha: ' . $resp->fecha);
                $invoice->setAutorizado(true);
                $invoice->setSinrespuesta(false);
                $invoice->setMensajeError("");
                $invoice->setFechaAutorizacion($resp->fecha);
                $invoice->setXmlAutorizado($resp->comprobante);
                $invoice->setStatus(Invoice::CLOSED);
                $invoice->setForcefullyClosed(true);
                $em->persist($invoice);
                $em->flush();
            } else {
                $this->addTranslatedMessage($resp, 'danger');
            }
        } catch (Exception $exception) {
            return $exception->getMessage();
        }

        return $respuesta;
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->addFlash($status, $this->translator->trans($message, [], 'invoice'));
    }

}
