<?php

namespace App\Controller;

use App\Entity\Model\Customer;
use App\Entity\Model\Empresa;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;
use App\Entity\Model\User;
use App\Form\ContactFormType;
use App\Form\RegistrationFormType;
use App\Security\LoginFormAuthenticator;
use App\Service\EmFactory;
use App\Util\Funciones;
use App\Util\RestApiFunciones;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ManagerRegistry;
use JMS\Serializer\Exception\Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Guard\GuardAuthenticatorHandler;
use Symfony\Component\Security\Http\Authenticator\InteractiveAuthenticatorInterface;
use Symfony\Component\Security\Http\Authenticator\Passport\Badge\UserBadge;
use Symfony\Component\Security\Http\Authenticator\Passport\SelfValidatingPassport;
use Symfony\Component\Security\Http\Event\AuthenticationTokenCreatedEvent;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\Security\Http\Event\LoginSuccessEvent;
use Symfony\Component\Security\Http\SecurityEvents;

class RegistrationController extends AbstractController
{
    /**
     * @Route("/svycar/register/{slug}", name="app_register")
     */
    public function register(Request $request,
                             UserPasswordHasherInterface $passwordEncoder,
                             EventDispatcherInterface $dispatcher,
                             TokenStorageInterface $tokenStorage,
                             LoginFormAuthenticator $authenticator,
                             EntityManagerInterface $entityManager,
                             ManagerRegistry $doctrine,
                             $slug): Response
    {
        if ($this->isGranted("IS_AUTHENTICATED_FULLY")) {
            return $this->redirectToRoute("inicio");
        }

        $planId = $slug ?? 0;

        $user = new User();

        if ($request->isMethod('GET')) {
            $user->setPlanId((int) $planId);
        }

        $form = $this->createForm(RegistrationFormType::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // encode the plain password
            $user->setPassword(
                $passwordEncoder->hashPassword(
                    $user,
                    $form->get('plainPassword')->getData()
                )
            );
            $user->setDataBase($this->getParameter('base_app'));

            /*$ip = $_SERVER['REMOTE_ADDR']; // This will contain the ip of the request

            // You can use a more sophisticated method to retrieve the content of a webpage with php using a library or something
            // We will retrieve quickly with the file_get_contents
            $dataArray = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=".$ip));

            var_dump($dataArray);

            // outputs something like (obviously with the data of your IP) :

            // geoplugin_countryCode => "DE",
            // geoplugin_countryName => "Germany"
            // geoplugin_continentCode => "EU"

            echo "Hello visitor from: ".$dataArray["geoplugin_countryName"];
            */

            try {
                $entityManager->getConnection()->beginTransaction();
                $entityManager->getConnection()->setAutoCommit(false);
                $entityManager->persist($user);
                $entityManager->flush();

                $firewallName = 'main';

                $passport = new SelfValidatingPassport(
                    new UserBadge($user->getUserIdentifier(), function () use ($user) {
                        return $user;
                    })
                );

                $token = $authenticator->createToken($passport, $firewallName);
                //$token = $authenticator->createAuthenticatedToken($passport, $firewallName);

                /** @var TokenInterface $token */
                $token = $dispatcher->dispatch(
                    new AuthenticationTokenCreatedEvent($token, $passport)
                )->getAuthenticatedToken();

                //$token->setAttributes($attributes);

                /** @see AuthenticatorManager::handleAuthenticationSuccess() */

                $tokenStorage->setToken($token);
                $response = $authenticator->onAuthenticationSuccess($request, $token, 'nuevo');

                if ($authenticator instanceof InteractiveAuthenticatorInterface && $authenticator->isInteractive()) {
                    $loginEvent = new InteractiveLoginEvent($request, $token);
                    $dispatcher->dispatch($loginEvent, SecurityEvents::INTERACTIVE_LOGIN);
                }

                $dispatcher->dispatch(
                    $loginSuccessEvent = new LoginSuccessEvent(
                        $authenticator,
                        $passport,
                        $token,
                        $request,
                        $response,
                        $firewallName
                    )
                );
                $entityManager->getConnection()->commit();
                $entityManager->clear();

                return $loginSuccessEvent->getResponse();
            }
            catch (\Exception $ex){
                $entityManager->getConnection()->rollback();
            }
        }

        $logoportada = '/assets/static/images/bg3.jpg';
        try {
            $em = $doctrine->getManager('default');
            $repo = $em->getRepository('App\Entity\Model\Property');
            $path = $repo->getValue('logoportada');
            $logoportada = DIRECTORY_SEPARATOR . $path;
        } catch (\Exception $ex) {

        }

        return $this->render('security/register.html.twig', [
            'registrationForm' => $form->createView(),
            'logoportada' => $logoportada
        ]);
    }
    /**
     * @Route("/register/plan", name="app_register_plan")
     */
    public function planAction(EmFactory $emFactory, Request $request): Response
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        if (!$empresa) {
            $empresa = new Empresa();

            //$user = new User();
            $empresa->setRuc($user->getRuc());
            $empresa->setEmail($user->getEmail());
            $empresa->setRazonSocial($user->getRazonSocial());
            $empresa->setDirEstablecimiento("Dirección Empresa");
            $empresa->setDireccionMatriz("Direccion Empresa");
            $empresa->setTelefono("000");
            $empresa->setCurrency("USD");
            $empresa->setTipoAmbiente("1");
            $DatetimeFechaActual = new \DateTime("now");
            $DatetimeFechaActual->add(new \DateInterval('P1Y'));
            $empresa->setFechaCaducaFirma($DatetimeFechaActual);

            $empresa->setMailHost($this->getParameter('mail_host'));
            $empresa->setMailPort($this->getParameter('mail_port'));
            $empresa->setMailStarttls($this->getParameter('mail_tls'));
            $empresa->setMailfrom($this->getParameter('mail_from'));
            $empresa->setPassmail($this->getParameter('mail_pass'));

            $em->persist($empresa);
            $em->flush();

            $app_url = $this->getParameter('api_url');
            $msg = Funciones::setEmisorApi($empresa, null, null, $app_url);
            if($msg !== null)
                $this->addFlash('danger', $msg);

            $data["razonSocial"] = $empresa->getRazonSocial();
            $data["ruc"] = $empresa->getRuc();
            $data["dirEstablecimiento"] = $empresa->getDirEstablecimiento();
            $data["telefono"] = $empresa->getTelefono();
            $data["email"] = $empresa->getEmail();
            $data["url"] = $empresa->getUrl();
            $data["rutaLogo"] = $empresa->getRutaLogo();
            $data["nombreComercial"] = $empresa->getNombreComercial();
            $data["decPunit"] = $empresa->getDecPunit();

            $consfinal = new Customer();
            $consfinal->setEmpresa($empresa);
            $consfinal->setEmail($empresa->getEmail());
            $consfinal->setName('CONSUMIDOR FINAL');
            $consfinal->setInvoicingAddress('S/N');
            $consfinal->setTipoDocumento('07');
            $consfinal->setTelefono('000');
            $consfinal->setIdentification('9999999999999');

            $em->persist($consfinal);

            $serie = new Series();
            $serie->setName("MATRIZ");
            $serie->setValue("001100");
            $serie->setIniFactura(1);
            $serie->setIniRetencion(1);
            $serie->setIniCredito(1);
            $serie->setIniLiquidacion(1);
            $serie->setIniDebito(1);
            $serie->setEnabled(true);
            $serie->setEmpresa($empresa);

            $em->persist($serie);

            $tax = new Tax();
            $tax->setName("IVA 12");
            $tax->setValue(12);
            $tax->setActive(true);
            $tax->setIsDefault(true);
            $tax->setEmpresa($empresa);

            $em->persist($tax);

            $tax = new Tax();
            $tax->setName("IVA 0");
            $tax->setValue(0);
            $tax->setActive(false);
            $tax->setIsDefault(false);
            $tax->setEmpresa($empresa);

            $em->persist($tax);

            $em->flush();
        }

        $planesRepo = $em->getRepository('App\Entity\Model\Planes');
        $planes = $planesRepo->findTodos();

        return $this->render('base_plan.html.twig',
            array(
                'planes' => $planes,

            ));
    }

    /**
     * @Route("/register/plan/emp{id}", name="app_register_plan_add")
     *
     */
    public function addPlanAction($id, EmFactory $emFactory)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $plan = $em->getRepository('App\Entity\Model\Planes')->findById($id);
        if ($plan) {

            $empresa->setPlan($plan);
            $empresa->setCostoplan($plan->getPrecioMes());

            if($plan->getIlimitado())
                $empresa->setCmpContratados(-1);
            else
                $empresa->setCmpContratados($plan->getNumFacMes());

            $em->persist($empresa);
            $em->flush();

            //$this->addTranslatedMessage('flash.updated');

            return $this->redirect($this->generateUrl('global_settings'));
        }

        return $this->redirect($this->generateUrl('app_register_plan'));
    }

    /**
     * @Route("/register/plan/{empid}/updateemp{planid}", name="app_register_plan_update")
     *
     */
    public function updatePlanAction($empid, $planid, EmFactory $emFactory)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneBy(['id' => $empid]);

        $plan = $em->getRepository('App\Entity\Model\Planes')->findById($planid);
        if ($plan) {

            $empresa->setPlan($plan);
            $empresa->setCostoplan($plan->getPrecioMes());
            $empresa->setPuedefacturar(false);
            $empresa->setMensaje('Actualización de plan valores pendientes por cancelar.');
            $em->persist($empresa);
            $em->flush();

            //$this->addTranslatedMessage('flash.updated');

            return $this->redirect($this->generateUrl('realizar_pago_cli'));
        }

        return $this->redirect($this->generateUrl('invoice_index'));
    }

    /**
     * @Route("/asoiinfo/ayuda", name="app_ayuda")
     */
    public function ayudaAction(Request $request,
                                UserPasswordEncoderInterface $passwordEncoder,
                                GuardAuthenticatorHandler $guardHandler,
                                LoginFormAuthenticator $authenticator,
                                TokenStorageInterface $tokenStorage): Response
    {

        // force logout of previous user
        $tokenStorage->setToken(null);

        /*if($this->isGranted("IS_AUTHENTICATED_FULLY"))
        {
            return $this->redirectToRoute("global_settings");
        }*/

        $logoportada = '/assets/static/images/bg3.jpg';
        $numtelefono = "";
        $pagina_web = "";
        try {
            $em = $this->getDoctrine()->getManager('default');
            $repo = $em->getRepository('App\Entity\Model\Property');
            $path = $repo->getValue('logoportada');
            $numtelefono = $repo->getValue('whatsapp');
            $pagina_web = $repo->getValue('pagina_web');
            $logoportada = DIRECTORY_SEPARATOR . $path;
        } catch (\Exception $ex) {

        }

        return $this->render('ayuda.html.twig', [
            //'registrationForm' => $form->createView(),
            'logoportada' => $logoportada,
            'telefono' => $numtelefono,
            'paginaweb' => $pagina_web
        ]);
    }

    /**
     * @Route("/asoiinfo/frmcontact", name="app_contact_frm")
     */
    public function contactAction(Request $request,
                                  UserPasswordEncoderInterface $passwordEncoder,
                                  GuardAuthenticatorHandler $guardHandler,
                                  LoginFormAuthenticator $authenticator,
                                  TokenStorageInterface $tokenStorage): Response
    {

        // force logout of previous user
        $tokenStorage->setToken(null);


        $logoportada = '/assets/static/images/bg3.jpg';

        $em = $this->getDoctrine()->getManager('default');
        $repo = $em->getRepository('App\Entity\Model\Property');

        $path = $repo->getValue('logoportada');
        $logoportada = DIRECTORY_SEPARATOR . $path;

        $data["email"] = "";
        $data["nombre"] = "";
        $data["mensaje"] = "";

        $form = $this->createForm(ContactFormType::class, $data);
        $form->handleRequest($request);

        try {
            if ($form->isSubmitted() && $form->isValid()) {
                $formData = $form->getData();
                $from = $repo->getValue('cuenta_correo');
                $pass = $repo->getValue('password_smtp');
                $server = $repo->getValue('smtpserver');
                $port = $repo->getValue('port_smtp');
                $to_mail = $repo->getValue('contacto_email');

                $mailuser = $from;
                $mailpass = $pass;
                $mailhost = $server;
                $mailport = $port;
                $mailencrypt = 'ssl';

                if (strcmp($mailhost, "smtp.gmail.com") == 0)
                    $mailencrypt = "tls";

                $transport = new \Swift_SmtpTransport();

                $transport->setAuthMode('login');
                $transport->setHost($mailhost);
                $transport->setPort($mailport);
                $transport->setEncryption($mailencrypt);
                $transport->setUsername($mailuser);
                $transport->setPassword($mailpass);

                $mailer = new \Swift_Mailer($transport);

                $message = new \Swift_Message();
                $message->setCharset('utf8');

                $message->setSubject('Mensaje desde Portal Facturacion');
                $message->setFrom($from, $formData["nombre"]);
                $message->setTo($to_mail);
                $user = new User();
                $html = '<p>' . $formData["nombre"] . ' ha enviado el siguiente mensaje;</p>
                    <p>Mensaje: ' . $formData["mensaje"] . '</p>
                    <p>Email: ' . $formData["email"] . '</p>
            ';

                $message->setBody($html, 'text/html');


                $result = $mailer->send($message, $failures);
                //$this->addTranslatedMessage('Mensaje enviado');


            }
        } catch (Exception $ex) {
            //$this->addTranslatedMessage('Error :' . $ex->getMessage(), 'danger');
        }
        catch (Swift_RfcComplianceException $ex){
            //$this->addTranslatedMessage('Error :' . $ex->getMessage(), 'danger');
        }
        return $this->render('contact.html.twig', [
            //'registrationForm' => $form->createView(),
            'logoportada' => $logoportada,
            'form' => $form->createView(),

        ]);
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->get('session')
            ->getFlashBag()
            ->add($status, $message);

    }

    /*protected function setEmisorApi(Empresa $empresa, $ruta_firma, $ruta_logo)
    {

        $app_url = $this->getParameter('api_url');
        $error = false;

        $data = array(
            'razon_social' => $empresa->getRazonSocial(),
            'nombre_comercial' => $empresa->getNombreComercial(),
            'dir_establecimiento' => $empresa->getDirEstablecimiento(),
            'cod_establecimiento' => $empresa->getCodEstablecimiento(),
            'contribuyente_especial' => $empresa->getContribuyenteEspecial(),
            'lleva_contabilidad' => $empresa->getLlevaContabilidad() === true ? 1 : 0,
            'cod_punto_emision' => '000',
            'tipo_ambiente' => $empresa->getTipoAmbiente() === 1 ? 'PRODUCCION' : 'PRUEBAS',
            'direccion_matriz' => $empresa->getDireccionMatriz(),
            'pass_firma' => $empresa->getPassFirma(),
            'mail_host' => $empresa->getMailHost(),
            'mail_port' => $empresa->getMailPort(),
            'mailfrom' => $empresa->getMailfrom(),
            'passmail' => $empresa->getPassmail(),
            'mail_starttls' => $empresa->getMailStarttls(),
            'emisor_id' => '-1',
            'agente_ret' => $empresa->getAgenteRet() === true ? 1 : 0,
        );

        if ($ruta_logo)
            $data['ruta_logo'] = $ruta_logo;
        if ($ruta_firma)
            $data['ruta_firma'] = $ruta_firma;

        $json = "";

        try {
            //$serializer = SerializerBuilder::create()->build();
            //$json = $serializer->serialize($data, 'json');
            $json = json_encode($data, JSON_UNESCAPED_UNICODE);
        } catch (\Exception $e) {

        }

        $resp = RestApiFunciones::enviarEmisorApi($error, $empresa->getRuc(), $json, $app_url, $ruta_firma, $ruta_logo);

        if ($error) {
            $msg = "Error envio servidor api, " . json_encode($resp);
            $this->get('session')->getFlashBag()->add('danger', $msg);
        } else {
            try {
                unlink($data['ruta_logo']);
            } catch (\Exception $ex) {
            }
            try {
                unlink($data['ruta_firma']);
            } catch (\Exception $ex) {
            }
        }
    }*/

}

