<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 11/09/2017
 * Time: 11:10
 */

namespace App\Electronico\Facturas;


use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class Detalle
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("codigoPrincipal")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codigoPrincipal;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codigoAuxiliar")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codigoAuxiliar;

    /**
     * @Serializer\Type("string")
     * @SerializedName("descripcion")
     * @Serializer\XmlElement(cdata=false)
     */
    private $descripcion;

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $cantidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("precioUnitario")
     * @Serializer\XmlElement(cdata=false)
     */
    private $precioUnitario;

    /**
     * @Serializer\Type("string")
     * @SerializedName("descuento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $descuento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("precioTotalSinImpuesto")
     * @Serializer\XmlElement(cdata=false)
     */
    private $precioTotalSinImpuesto;


    /**
     * @SerializedName("impuestos")
     * @XmlList(inline = false, entry = "impuesto")
     */
    private $impuestos;


    public function __construct()
    {

    }

    /**
     * @return mixed
     */
    public function getCodigoPrincipal()
    {
        return $this->codigoPrincipal;
    }

    /**
     * @param mixed $codigoPrincipal
     */
    public function setCodigoPrincipal($codigoPrincipal)
    {
        $this->codigoPrincipal = $codigoPrincipal;
    }

    /**
     * @return mixed
     */
    public function getCodigoAuxiliar()
    {
        return $this->codigoAuxiliar;
    }

    /**
     * @param mixed $codigoAuxiliar
     */
    public function setCodigoAuxiliar($codigoAuxiliar)
    {
        $this->codigoAuxiliar = $codigoAuxiliar;
    }

    /**
     * @return mixed
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * @param mixed $descripcion
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    }

    /**
     * @return mixed
     */
    public function getCantidad()
    {
        return $this->cantidad;
    }

    /**
     * @param mixed $cantidad
     */
    public function setCantidad($cantidad, $decimal=2)
    {
        $this->cantidad = number_format($cantidad, $decimal, '.', '');
    }

    /**
     * @return mixed
     */
    public function getPrecioUnitario()
    {
        return $this->precioUnitario;
    }

    /**
     * @param mixed $precioUnitario
     */
    public function setPrecioUnitario($precioUnitario, $decimal=2)
    {
        $this->precioUnitario = number_format($precioUnitario, $decimal, '.', '');
    }

    /**
     * @return mixed
     */
    public function getDescuento()
    {
        return $this->descuento;
    }

    /**
     * @param mixed $descuento
     */
    public function setDescuento($descuento)
    {
        $this->descuento = number_format($descuento, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getPrecioTotalSinImpuesto()
    {
        return $this->precioTotalSinImpuesto;
    }

    /**
     * @param mixed $precioTotalSinImpuesto
     */
    public function setPrecioTotalSinImpuesto($precioTotalSinImpuesto)
    {
        $this->precioTotalSinImpuesto = number_format($precioTotalSinImpuesto, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getImpuestos()
    {
        return $this->impuestos;
    }

    /**
     * @param mixed $impuestos
     */
    public function setImpuestos(array $impuestos)
    {
        $this->impuestos = $impuestos;
    }
}
