<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 07/09/2017
 * Time: 17:57
 */

namespace App\Electronico\LiquidacionCompra;

use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class ImpuestoDetalle
{
    /**
     * @Serializer\Type("integer")
     * @SerializedName("codigo")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigo;

    /**
     * @Serializer\Type("integer")
     * @SerializedName("codigoPorcentaje")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigoPorcentaje;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tarifa")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tarifa;

    /**
     * @Serializer\Type("string")
     * @SerializedName("baseImponibleReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $baseImponibleReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("impuestoReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $impuestoReembolso;

    /**
     * @return mixed
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param mixed $codigo
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return mixed
     */
    public function getCodigoPorcentaje()
    {
        return $this->codigoPorcentaje;
    }

    /**
     * @param mixed $codigoPorcentaje
     */
    public function setCodigoPorcentaje($codigoPorcentaje)
    {
        $this->codigoPorcentaje = $codigoPorcentaje;
    }

    /**
     * @return mixed
     */
    public function getTarifa()
    {
        return $this->tarifa;
    }

    /**
     * @param mixed $tarifa
     */
    public function setTarifa($tarifa)
    {
        $this->tarifa = $tarifa;
    }

    /**
     * @return mixed
     */
    public function getBaseImponibleReembolso()
    {
        return $this->baseImponibleReembolso;
    }

    /**
     * @param mixed $baseImponible
     */
    public function setBaseImponibleReembolso($baseImponible)
    {
        $this->baseImponibleReembolso = number_format($baseImponible, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getImpuestoReembolso()
    {
        return $this->impuestoReembolso;
    }

    /**
     * @param mixed $ImpuestoReembolso
     */
    public function setImpuestoReembolso($valor)
    {
        $this->impuestoReembolso = number_format($valor, 2, '.', '');
    }
}
