<?php

namespace App\Electronico\Retencion;

use App\Electronico\InfoTributaria;
use JMS\Serializer\Annotation\Inline;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\XmlAttribute;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation\XmlRoot;

/** @XmlRoot("comprobanteRetencion")
 */
class ComprobanteRetencion
{

    /** @XmlAttribute
     *  @Type("string")
     */
    private $id ='comprobante';

    /** @XmlAttribute
     *  @Type("string")
     */
    private $version = '1.0.0';

    /**
     * @SerializedName("infoTributaria")
     */
    private $infoTributaria;

    /**
     * @SerializedName("infoCompRetencion")
     */
    private $infoCompRetencion;

    /**
     * @SerializedName("impuestos")
     * @XmlList(inline = false, entry = "impuesto")
     */
    private $impuestos;


    /**
     * @SerializedName("infoAdicional")
     * @XmlList(inline = false, entry = "campoAdicional")
     */
        private  $infoAdicional;


    public function __construct()
    {
        $this->infoCompRetencion= new InfoCompRetencion();
        $this->infoTributaria = new InfoTributaria();
    }

    /**
     * @return mixed
     */
    public function getInfoTributaria()
    {
        return $this->infoTributaria;
    }

    /**
     * @param mixed $infoTributaria
     */
    public function setInfoTributaria(InfoTributaria $infoTributaria)
    {
        $this->infoTributaria = $infoTributaria;
    }

    /**
     * @return mixed
     */
    public function getInfoCompRetencion()
    {
        return $this->infoCompRetencion;
    }

    /**
     * @param mixed $infoCompRetencion
     */
    public function setInfoCompRetencion($infoCompRetencion)
    {
        $this->infoCompRetencion = $infoCompRetencion;
    }

    /**
     * @return mixed
     */
    public function getInfoAdicional()
    {
        return $this->infoAdicional;
    }

    /**
     * @param mixed $infoAdicional
     */
    public function setInfoAdicional(array  $infoAdicional)
    {
        $this->infoAdicional = $infoAdicional;
    }

    /**
     * @return mixed
     */
    public function getImpuestos()
    {
        return $this->impuestos;
    }

    /**
     * @param mixed $impuestos
     */
    public function setImpuestos(array $impuestos)
    {
        $this->impuestos = $impuestos;
    }

}
