<?php

namespace App\Electronico\Retencion;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;


class InfoCompRetencion
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmision")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmision;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirEstablecimiento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirEstablecimiento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("contribuyenteEspecial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $contribuyenteEspecial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("obligadoContabilidad")
     * @Serializer\XmlElement(cdata=false)
     */
    private $obligadoContabilidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoIdentificacionSujetoRetenido")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoIdentificacionSujetoRetenido;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocialSujetoRetenido")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocialSujetoRetenido;

    /**
     * @Serializer\Type("string")
     * @SerializedName("identificacionSujetoRetenido")
     * @Serializer\XmlElement(cdata=false)
     */
    private $identificacionSujetoRetenido;

    /**
     * @Serializer\Type("string")
     * @SerializedName("periodoFiscal")
     * @Serializer\XmlElement(cdata=false)
     */
    private $periodoFiscal;

    public function __construct()
    {
    }

    /**
     * @return mixed
     */
    public function getFechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * @param mixed $fechaEmision
     */
    public function setFechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
    }

    /**
     * @return mixed
     */
    public function getDirEstablecimiento()
    {
        return $this->dirEstablecimiento;
    }

    /**
     * @param mixed $dirEstablecimiento
     */
    public function setDirEstablecimiento($dirEstablecimiento)
    {
        $this->dirEstablecimiento = $dirEstablecimiento;
    }

    /**
     * @return mixed
     */
    public function getContribuyenteEspecial()
    {
        return $this->contribuyenteEspecial;
    }

    /**
     * @param mixed $contribuyenteEspecial
     */
    public function setContribuyenteEspecial($contribuyenteEspecial)
    {
        $this->contribuyenteEspecial = $contribuyenteEspecial;
    }

    /**
     * @return mixed
     */
    public function getObligadoContabilidad()
    {
        return $this->obligadoContabilidad;
    }

    /**
     * @param mixed $obligadoContabilidad
     */
    public function setObligadoContabilidad(bool  $obligadoContabilidad)
    {
        $this->obligadoContabilidad = $obligadoContabilidad ? 'SI' : 'NO';
    }

    /**
     * @return mixed
     */
    public function getTipoIdentificacionSujetoRetenido()
    {
        return $this->tipoIdentificacionSujetoRetenido;
    }


    /**
     * @param mixed $tipoIdentificacionSujetoRetenido
     */
    public function setTipoIdentificacionSujetoRetenido($tipoIdentificacionSujetoRetenido)
    {
        /*if($tipoIdentificacionSujetoRetenido == 'C')
            $this->tipoIdentificacionSujetoRetenido = '05';
        elseif($tipoIdentificacionSujetoRetenido == 'R')
                $this->tipoIdentificacionSujetoRetenido = '04';
        elseif($tipoIdentificacionSujetoRetenido == 'P')
            $this->tipoIdentificacionSujetoRetenido = '06';
        else
            $this->tipoIdentificacionSujetoRetenido = '07';*/
        $this->tipoIdentificacionSujetoRetenido = $tipoIdentificacionSujetoRetenido;
    }

    /**
     * @return mixed
     */
    public function getRazonSocialSujetoRetenido()
    {
        return $this->razonSocialSujetoRetenido;
    }

    /**
     * @param mixed $razonSocialSujetoRetenido
     */
    public function setRazonSocialSujetoRetenido($razonSocialSujetoRetenido)
    {
        $this->razonSocialSujetoRetenido = $razonSocialSujetoRetenido;
    }

    /**
     * @return mixed
     */
    public function getIdentificacionSujetoRetenido()
    {
        return $this->identificacionSujetoRetenido;
    }

    /**
     * @param mixed $identificacionSujetoRetenido
     */
    public function setIdentificacionSujetoRetenido($identificacionSujetoRetenido)
    {
        $this->identificacionSujetoRetenido = $identificacionSujetoRetenido;
    }

    /**
     * @return mixed
     */
    public function getPeriodoFiscal()
    {
        return $this->periodoFiscal;
    }

    /**
     * @param mixed $periodoFiscal
     */
    public function setPeriodoFiscal($periodoFiscal)
    {
        $this->periodoFiscal = $periodoFiscal;
    }


}

