<?php

namespace App\Form;

use App\Service\EmFactory;
use App\Entity\Model\Item;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AbstractCreditoType extends AbstractType
{
    private $manager;
    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $series =  $this->manager->getRepository('App\Entity\Model\Series')->findSeriesEmpresa($empresa->getId());

        $repo = $this->manager->getRepository('App\Entity\Model\Ncredito');
        $numero = 0;
        if ($repo && $series[0])
        {
            $numero = $repo->getNextNumber($series[0], $empresa->getId());
        }

        $builder
            ->add('number', TextType::class, [
                'label' => 'form.numero',
                'data' => str_pad($numero, 9, "0", STR_PAD_LEFT),
                'disabled' => true, //TODO PARA IGNORAR EL SUBMITTED
                'translation_domain' => 'invoice',
                'attr' => array('autocomplete' => 'off'),
            ])
            ->add('customer_name', TextType::class, [
                'required'=>true,
                'label' => 'form.customer_name',
                'translation_domain' => 'invoice',
                'attr' => ['readonly'=>true, 'autocomplete' => 'off'],
            ])
            ->add('customer_identification', TextType::class, [
                'required' => true,
                'label' => 'form.customer_identification',
                'translation_domain' => 'invoice',
                'attr' => array('autocomplete' => 'on'),
            ])
            ->add('customer_email', null, [
                'required' => true,
                'label' => 'form.customer_email',
                'translation_domain' => 'invoice',
                'attr' => ['readonly'=>true, 'autocomplete' => 'off'],
            ])
            ->add('invoicing_address', TextType::class, [
                'attr' => ['readonly'=>true, 'rows' => 1, 'autocomplete' => 'off'],
                'label' => 'form.invoicing_address',
                'translation_domain' => 'invoice',
            ])
            ->add('issue_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.issue_date',
                'translation_domain' => 'invoice',
                'attr' => array('autocomplete' => 'off'),
            ])

            /*->add('shipping_address', null, [
                'attr' => ['rows' => 3],
                'label' => 'form.shipping_address',
                'translation_domain' => 'invoice',
            ])
            ->add('contact_person', null, [
                'label' => 'form.contact_person',
                'translation_domain' => 'invoice',
            ])

            ->add('terms', null, [
                'attr' => ['rows' => 5],
                'label' => 'form.terms',
                'translation_domain' => 'invoice',
            ])
            */
            ->add('notes', TextType::class, [
                'label' => 'form.notes',
                'attr' => ['class'=>'sv_uppercase', 'maxlength'=>200, 'autocomplete' => 'off'],
                'required' => false,
                'translation_domain' => 'invoice',
            ])
            /*
            ->add('note1', TextType::class, [
                'label' => 'form.observacion',
                'attr' => ['class'=>'sv_uppercase', 'maxlength'=>200],
                'required' => false,
                'translation_domain' => 'invoice',
            ])
            */
        ;

        $newItem = new Item();
        $newItem->setTaxes($this->manager->getRepository('App\Entity\Model\Tax')->findTaxDefault($empresa->getId()));

        $builder->add('items', CollectionType::class, array(
            'entry_type' => 'App\Form\ItemType',
            'allow_add' => true,
            'allow_delete' => true,
            'prototype' => true,
            'by_reference' => false,
            'label' => false,
            'prototype_data' => $newItem,
        ));

        //$series =  $this->manager->getRepository('App\Entity\Model\Series')->findSeriesEmpresa($empresa->getId());

        $builder->add('series', EntityType::class, array(
            'class' => 'App\Entity\Model\Series',
            'choice_label' => 'value',
            'attr' => ['readonly'=>true],
            'required' => true,
            //'placeholder' => 'Seleccione una serie ...',
            'label' => 'form.series',
            'translation_domain' => 'invoice',
            'choices' => $series
        ));


        /*$builder->add('series', TextType::class, [
            'label' => 'form.series',
            'attr' => ['class'=>'sv_uppercase', 'maxlength'=>6,'readonly'=>true,'value'=>$series[0]->getValue()],
            'required' => true,
            'translation_domain' => 'invoice',
        ]);*/
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\AbstractInvoice',
        ]);
    }
}
