<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

class ElectroSettingsType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('contribuyenteEspecial', TextType::class, [
                'required' => false,
                'label' => 'form.contriespecial',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
           ->add('passFirma', TextType::class, [
                'required' => false,
                'label' => 'form.passfirma',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('rutaFirma', FileType::class, [
                'required' => false,
                //'attr' => ['style' =>"color: transparent"],
                'label' => 'form.firma',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('tipoAmbiente', ChoiceType::class, [
                'label' => 'form.ambiente',
                'required' => true,
                'choices' => ['form.pruebas' => '1', 'form.produccion' => '2'],
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('llevaContabilidad', ChoiceType::class, [
                'label' => 'form.llevaconta',
                'required' => true,
                'choices' => [
                    'form.si' => true,
                    'form.no' => false
                ],
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('agenteRet', TextType::class, [
                'required' => false,
                'label' => 'form.agenteret',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            /*->add('rimpe', CheckboxType::class, [
                'required' => false,
                'label' => 'form.rimpe',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])*/
            ->add('rimpe', ChoiceType::class, [
                'label' => 'Tipo Contribuyente',
                'required' => true,
                'choices' => [
                    'REGIMEN GENERAL' => 0,
                    'REGIMEN RIMPE' => 3,
                    'NEGOCIO POPULAR - REGIMEN RIMPE' => 4
                ],
                'expanded' => false,
                'multiple' => false,
                'attr' => ['autocomplete' => 'off'],
            ])
        ;

        $builder->get('rutaFirma')
            ->addModelTransformer(new CallbackTransformer(
                static function ($filename) {
                    return $filename ? new File($filename, false) : null;
                },
                static function ($file) {
                    return $file;
                }
            ));


    }

}
