<?php

namespace App\Form;

use App\Entity\Model\Empresa;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;
use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use App\Entity\Model\Invoice;
use Symfony\Component\Security\Core\Security;

class SearchPagosAdminType extends AbstractType
{
    private $manager;
    private $security;
    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository('App\Entity\Model\Empresa');
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            ->add('terms', null, [
                'required' => false,
                'label' => 'search.terms',
                'translation_domain' => 'invoice',
            ])
            ->add('status', ChoiceType::class, [
                'label' => 'Estado',
                'translation_domain' => 'invoice',
                'choices' => [
                    'AUTORIZADO' => true,
                    'RECHAZADO' => false
                ],
                'required' => false,
            ])
            ->add('date_from', DateType::class, [
                'label' => 'search.date_from',
                'translation_domain' => 'invoice',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('date_to', DateType::class, [
                'label' => 'search.date_to',
                'translation_domain' => 'invoice',
                'widget' => 'single_text',
                'required' => false,
            ])
            /*->add('customer', null, [
                'label' => 'search.customer',
                'translation_domain' => 'invoice',
                'required' => false,
            ])
            */
        ;

        /*$builder->add('series', EntityType::class, [
            'label' => 'search.series',
            'translation_domain' => 'invoice',
            'class' => 'App\Entity\Model\Series',
            'choice_label' => 'name',
            'required' => false,
        ]);
        */

       /* ->add('socios', EntityType::class, [
        'label' => 'Socio',
        'class' => 'SiwappUserBundle:User',
        'query_builder' => function (EntityRepository $er) {
            return $er->createQueryBuilder('u')
                ->where("u.is_socio = 1")
                ->orderBy('u.name', 'ASC');
        },
        'choice_label' => 'name',
        'required' => false,
    ])
       */


         $builder->add('empresas', EntityType::class, array(
            'class' => 'App\Entity\Model\Empresa',
            'label' => 'Empresa',
            'choice_label' => 'razonSocial',
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('t')
                    //->where('t.enabled = 1')
                    //->andWhere('t.empresa = :empresa_id')
                    //->setParameter('empresa_id', $this->empresa->getId());
                ->orderBy('t.razonSocial');

            },
            'multiple' => false,
            'required' => false,
        ));


    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'csrf_protection' => false,
        ));
    }
}
