<?php

namespace App\Controller\Admin;

use App\Entity\Model\Planes;
use App\Service\EmFactory;
use Container8KqKcNs\getDebug_FileLinkFormatter_UrlFormatService;
use Knp\Component\Pager\PaginatorInterface;
use PDO;
use PDOException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @Route("/svadmin/pagos")
 */
class AdminPagosController extends AbstractController
{

    protected $translator;

    /**
     * @Route("", name="admin_pagos_index")
     *
     */
    public function indexAction(EmFactory $emFactory, Request $request, PaginatorInterface $paginator, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');

        $repo = $em->getRepository('App\Entity\Model\PagoEmpresa');
        $repo->setPaginator($paginator);

        $limit = 50;

        $form = $this->createForm('App\Form\SearchPagosAdminType', null, [
            'action' => $this->generateUrl('admin_pagos_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            $pagination = $repo->paginatedSearch($form->getData(), $limit, $request->query->getInt('page', 1));
        } else {
            $pagination = $repo->paginatedSearch([], $limit, $request->query->getInt('page', 1));
        }

        $pagos = [];
        foreach ($pagination->getItems() as $item) {
            $pagos[] = $item;
        }

        $listForm = $this->createForm('App\Form\ListGenericType', $pagos, [
            'action' => $this->generateUrl('admin_pagos_index'),
        ]);
        $listForm->handleRequest($request);

        return $this->render('Admin\Pagos\index.html.twig',
            array(
                'pagos' => $pagos,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
                'search_form' => $form->createView(),
                'list_form' => $listForm->createView(),
            ));
    }

    /**
     * @Route("/new", name="admin_pagos_add")
     *
     */
    public function newAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $plan = new Planes();

        $form = $this->createForm('App\Form\PlanType', $plan, [
            'action' => $this->generateUrl('admin_plan_add'),
        ]);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            if ($plan->getIlimitado()) {
                $aux = $em->getRepository('App\Entity\Model\Planes')->findByIlimitado();

                if ($aux) {
                    $this->addTranslatedMessage('Ya existe un plan ilimitado registrado', 'danger');
                } else {
                    $em->persist($plan);
                    $em->flush();
                    $this->addTranslatedMessage('Plan Insertado');

                    return $this->redirect($this->generateUrl('admin_plan_index'));
                }
            } else {
                $em->persist($plan);
                $em->flush();
                $this->addTranslatedMessage('Plan Insertado');

                return $this->redirect($this->generateUrl('admin_plan_index'));
            }

        }
        return $this->render('Admin\Plan\edit.html.twig',
            array(
                'form' => $form->createView(),
                'entity' => $plan,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
            ));
    }


    /**
     * @Route("/edit/plan{id}", name="admin_pagos_edit")
     *
     */
    public function editAction($id, EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $entity = $em->getRepository('App\Entity\Model\PagoEmpresa')->findById($id);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PagoEmpresa entity.');
        }

        $plan = $entity->getEmpresa()->getPlan();
        if (!$plan) {
            //throw $this->createNotFoundException('Unable to find Plan entity.');
            $this->addTranslatedMessage('Empresa no tiene plan facturación asignado', 'danger');
        }

        $empresa = $entity->getEmpresa();
        $fechainicio = $entity->getEmpresa()->getFechaInicio();
        if (!$fechainicio)
            $this->addTranslatedMessage('Empresa no registra inicio de autorizaciones en producción', 'danger');

        //$dia = $fechainicio->format('d');
        //$anio = $fechainicio->format('Y');
        //$mes = $fechainicio->format('m');

        $anioactual = date('Y');
        $mesactual = date('n');

        $meses = [];
        $meses['ENERO'] = 1;
        $meses['FEBRERO'] = 2;
        $meses['MARZO'] = 3;
        $meses['ABRIL'] = 4;
        $meses['MAYO'] = 5;
        $meses['JUNIO'] = 6;
        $meses['JULIO'] = 7;
        $meses['AGOSTO'] = 8;
        $meses['SEPTIEMBRE'] = 9;
        $meses['OCTUBRE'] = 10;
        $meses['NOVIEMBRE'] = 11;
        $meses['DICIEMBRE'] = 12;

        $anios = [];
        $anios[$anioactual] = $anioactual;


        $form = $this->createForm('App\Form\PagoEmpresaType', $entity, [
            'action' => $this->generateUrl('admin_pagos_edit', array('id' => $id)),
            'mes' => $meses,
            'anio' => $anios
        ]);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {

            if ($form->isValid()) {

                $entity->setFechaAcreditacion(new \DateTime());

                $year = intval(date("Y"));
                $mes = intval($entity->getMes());

                $fechainicio  = new \DateTime($empresa->getFechaCaduca()->format('Y/m/d'));
                $caduca = new \DateTime($empresa->getFechaCaduca()->format('Y/m/d'));

                $empresa->setFechaInicio($fechainicio);

                //$plan = new Planes();
                //$empresa = new Empresa();

                $dias_pago = $plan->getDiasPago();
                $ncomprobantes = $plan->getNumFacMes();
                $caduca->add(new \DateInterval('P'.$dias_pago.'D'));
                $empresa->setFechaCaduca($caduca);

                $contratados = $empresa->getCmpContratados() === null ? 0 : $empresa->getCmpContratados() ;
                if($contratados === -1)
                    $contratados =0;

                $empresa->setCmpContratados($ncomprobantes+ $contratados);
                $em->persist($empresa);
                // Save.
                $em->persist($entity);
                $em->flush();
                $this->addTranslatedMessage('Registro Actualizado');
                return $this->redirect($this->generateUrl('admin_pagos_index'));

            }
        }


        return $this->render('Admin\Pagos\edit.html.twig',
            array(
                'entity' => $entity,
                'form' => $form->createView(),
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => 'USD',
                'plan' => $plan
            ));
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->get('session')
            ->getFlashBag()
            ->add($status, $this->translator->trans($message, [], 'invoice'));
    }

}
