<?php

namespace App\Controller;

use App\Electronico\Comprobante;
use App\Entity\Model\Customer;
use App\Entity\Model\Empresa;
use App\Entity\Model\PlacasSocios;
use App\Entity\Model\Planes;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;

use App\Entity\Model\TransporteSocio;
use App\Form\ResetPassFormType;
use App\Service\EmFactory;
use App\Util\Funciones;
use App\Util\RestApiFunciones;
use DateInterval;
use DateTime;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @Route("/configuration")
 */
class ConfigController extends AbstractController
{
    protected $translator;

    /**
     * @Route("/global_settings", name="global_settings")
     */
    public function globalSettingsAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator, LoggerInterface $logger)
    {
        $this->translator = $translator;

        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        if ($empresa != null) {
            //$empresa = new Empresa();
            $data["razonSocial"] = $empresa->getRazonSocial();
            $data["ruc"] = $empresa->getRuc();
            $data["dirEstablecimiento"] = $empresa->getDirEstablecimiento();
            $data["direccionMatriz"] = $empresa->getDireccionMatriz() === null ? $empresa->getDirEstablecimiento() : $empresa->getDireccionMatriz();
            $data["telefono"] = $empresa->getTelefono();
            $data["email"] = $empresa->getEmail();
            $data["url"] = $empresa->getUrl();
            $data["rutaLogo"] = $empresa->getRutaLogo();
            $data["nombreComercial"] = $empresa->getNombreComercial();
            $data["decPunit"] = $empresa->getDecPunit();
        } else {
            $empresa = new Empresa();
            //$user = new User();
            $empresa->setRuc($user->getRuc());
            $empresa->setEmail($user->getEmail());
            $empresa->setRazonSocial($user->getRazonSocial());
            $empresa->setDirEstablecimiento("Dirección Establecimiento Empresa");
            $empresa->setDireccionMatriz("Direccion Matriz Empresa");
            $empresa->setTelefono("000");
            $empresa->setCurrency("USD");
            $empresa->setTipoAmbiente("1");
            $empresa->setUserId($user->getId());
            $DatetimeFechaActual = new DateTime("now");
            $DatetimeFechaActual->add(new DateInterval('P1Y'));
            $empresa->setFechaCaducaFirma($DatetimeFechaActual);

            $em->persist($empresa);
            $em->flush();

            $data["razonSocial"] = $empresa->getRazonSocial();
            $data["ruc"] = $empresa->getRuc();
            $data["dirEstablecimiento"] = $empresa->getDirEstablecimiento();
            $data["direccionMatriz"] = $empresa->getDireccionMatriz();
            $data["telefono"] = $empresa->getTelefono();
            $data["email"] = $empresa->getEmail();
            $data["url"] = $empresa->getUrl();
            $data["rutaLogo"] = $empresa->getRutaLogo();
            $data["nombreComercial"] = $empresa->getNombreComercial();
            $data["decPunit"] = $empresa->getDecPunit();

            $consfinal = new Customer();
            $consfinal->setEmpresa($empresa);
            $consfinal->setEmail($empresa->getEmail());
            $consfinal->setName('CONSUMIDOR FINAL');
            $consfinal->setInvoicingAddress('S/N');
            $consfinal->setTipoDocumento('07');
            $consfinal->setTelefono('000');
            $consfinal->setIdentification('9999999999999');

            $em->persist($consfinal);

            $serie = new Series();
            $serie->setName("MATRIZ");
            $serie->setValue("001100");
            $serie->setIniFactura(1);
            $serie->setIniRetencion(1);
            $serie->setIniCredito(1);
            $serie->setIniLiquidacion(1);
            $serie->setIniDebito(1);
            $serie->setEnabled(true);
            $serie->setEmpresa($empresa);

            $em->persist($serie);

            $tax = new Tax();
            $tax->setName("IVA 12");
            $tax->setValue(12);
            $tax->setActive(true);
            $tax->setIsDefault(true);
            $tax->setEmpresa($empresa);

            $em->persist($tax);

            $tax = new Tax();
            $tax->setName("IVA 0");
            $tax->setValue(0);
            $tax->setActive(false);
            $tax->setIsDefault(false);
            $tax->setEmpresa($empresa);

            $em->persist($tax);

            $em->flush();
        }

        $all_taxes = $em->getRepository('App\Entity\Model\Tax')->findTaxesEmpresa($empresa->getId());
        $all_series = $em->getRepository('App\Entity\Model\Series')->findSeriesEmpresa($empresa->getId());

        $data['taxes'] = $all_taxes;
        $data['series'] = $all_series;

        if ($request->getMethod() === 'GET') {

            if ($empresa->getRutaLogo()) {
                $logo = $this->variosEmisorApi($empresa, 'logo');
                if ($logo !== null)
                    //$data['logo'] = 'data: '.mime_content_type($image).';base64,'.$imageData;
                    $data['logo'] = 'data: image/png;base64,' . $logo;
            }
        }

        $form = $this->createForm('App\Form\GlobalSettingsType', $data);

        if ($request->getMethod() === 'POST') {
            $form->handleRequest($request);

            if ($form->isSubmitted() && $form->isValid()) {

                $formData = $form->getData();
                $series = $formData['series'];
                $taxes = $formData['taxes'];
                unset($formData['series'], $formData['taxes']);

                if (!empty($formData['rutaLogo'])) {
                    /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                    $file = $formData['rutaLogo'];

                    $rutaLogo = $this->saveLogo($file, $empresa->getRuc(), $logger);

                    if ($rutaLogo != null) {
                        $formData['rutaLogo'] = $rutaLogo;
                    }
                } else {
                    // Unset the key otherwise the previous logo will be deleted.
                    if ($empresa->getRutaLogo())
                        $formData['rutaLogo'] = $empresa->getRutaLogo();
                    else
                        unset($formData['rutaLogo']);
                }

                if ($empresa === null)
                    $empresa = new Empresa();

                $empresa = $empresaRepo->setPropertiesFromArray($formData, $empresa);

                // Save series.
                foreach ($series as $item) {
                    $item->setEmpresa($empresa);
                    $em->persist($item);
                }
                // Remove series.
                foreach ($all_series as $item) {
                    if (!in_array($item, $series)) {
                        $em->remove($item);
                    }
                }
                // Save taxes.
                foreach ($taxes as $tax) {
                    $tax->setEmpresa($empresa);
                    $em->persist($tax);
                }
                // Remove taxes.
                foreach ($all_taxes as $item) {
                    if (!in_array($item, $taxes)) {
                        $em->remove($item);
                    }
                }

                $em->flush();
                //$this->addTranslatedMessage('flash.updated');

                $this->addFlash('success', $translator->trans('flash.updated', [], 'config'));

                //$this->setEmisorApi($empresa, null, isset($rutaLogo) ? $rutaLogo: null);

                $app_url = $this->getParameter('api_url');
                $msg = Funciones::setEmisorApi($empresa, null, isset($rutaLogo) ? $rutaLogo: null, $app_url);
                if($msg !== null)
                    $this->addFlash('danger', $msg);

                $logo = $this->variosEmisorApi($empresa, 'logo');
                if ($logo !== null) {
                    //$data['logo'] = 'data: '.mime_content_type($image).';base64,'.$imageData;
                    $data['logo'] = 'data: image/png;base64,' . $logo;
                    $data["rutaLogo"] = $empresa->getRutaLogo();
                }
                else{
                    $empresa->setRutaLogo(null);
                    $em->persist($empresa);
                    $em->flush();
                }
            }
        }
        return $this->render('Config\global_settings.html.twig',
            array(
                'form' => $form->createView(),
                'settings' => $data,
            ));
    }

    /**
     * @Route("/electro_settings", name="electro_settings")
     *
     */
    public function electroSettingsAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        if ($empresa != null) {
            //$empresa = new Empresa();
            $data["rutaFirma"] = $empresa->getRutaFirma();
            $data["passFirma"] = $empresa->getPassFirma();
            $data["tipoAmbiente"] = $empresa->getTipoAmbiente();
            $data["llevaContabilidad"] = $empresa->getLlevaContabilidad();
            $data["contribuyenteEspecial"] = $empresa->getContribuyenteEspecial();
            $data["agenteRet"] = $empresa->getAgenteRet();
            $data["rimpe"] = 0;
            if ($empresa->getRimpe())
                $data["rimpe"] = 3;
            elseif ($empresa->getNegpopular())
                $data["rimpe"] = 4;
            //$data["envioAutomatico"] = $empresa->getEnvioAutomatico();
            $data["envioMailAutomatico"] = $empresa->getEnvioMailAutomatico();
        }

        $form = $this->createForm('App\Form\ElectroSettingsType', $data);
        /*$form->add('envioAutomatico', CheckboxType::class, array(
            'required' => false,
            'label' => 'Envio Cola Autorizaciones',
            'translation_domain' => 'config',
        ));*/

        $form->add('envioMailAutomatico', CheckboxType::class, array(
            'required' => false,
            'label' => 'Envio Mail Automatico',
        ));

        if ($request->getMethod() === 'GET') {
            if ($empresa->getRutaFirma()) {
                $pathLogo = '../public' . DIRECTORY_SEPARATOR . 'firmaimage.png';

                $imagen = file_get_contents($pathLogo);
                $logo = base64_encode($imagen);
                if ($logo !== null)
                    //$data['logo'] = 'data: '.mime_content_type($image).';base64,'.$imageData;
                    $data['firma'] = 'data: image/png;base64,' . $logo;
            }
        }

        if ($request->getMethod() == 'POST') {
            $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {
                $formData = $form->getData();

                if (!empty($formData['rutaFirma'])) {
                    /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                    $file = $formData['rutaFirma'];

                    $rutaFirma = $this->saveFirma($file, $empresa->getRuc());

                    if ($rutaFirma != null)
                        $formData["rutaFirma"] = $rutaFirma;
                } else {
                    // Unset the key otherwise the previous logo will be deleted.
                    if ($empresa->getRutaFirma())
                        $formData['rutaFirma'] = $empresa->getRutaFirma();
                    else
                        unset($formData["rutaFirma"]);
                }

                if (empty($formData['passFirma'])) {
                    if ($empresa->getPassFirma())
                        $formData['passFirma'] = $empresa->getPassFirma();
                    else
                        unset($formData["passFirma"]);
                }

                $empresa = $empresaRepo->setPropertiesElectroFromArray($formData, $empresa);

                //$this->setEmisorApi($empresa, isset($rutaFirma) ? $rutaFirma: null, null);

                $app_url = $this->getParameter('api_url');
                $msg = Funciones::setEmisorApi($empresa, isset($rutaFirma) ? $rutaFirma: null, null, $app_url);
                if($msg !== null)
                    $this->addFlash('danger', $msg);

                /*** VALIDAR PASSWORD FIRMA ***/

                $app_url = $this->getParameter('api_url');

                $error = false;
                $resp = RestApiFunciones::validarPasswordFirma($error, $empresa->getRuc(), $app_url);

                if ($error) {
                    $this->addFlash('danger', "ERROR FIRMA ELECTRONICA: " . $resp);

                    $empresa->setRutaFirma(null);

                } else {
                    $empresa->setFechaCaducaFirma($resp->message);

                    $this->addTranslatedMessage('flash.updated');

                    $pathLogo = '../public' . DIRECTORY_SEPARATOR . 'firmaimage.png';

                    $imagen = file_get_contents($pathLogo);
                    $logo = base64_encode($imagen);
                    if ($logo !== null)
                        //$data['logo'] = 'data: '.mime_content_type($image).';base64,'.$imageData;
                        $data['firma'] = 'data: image/png;base64,' . $logo;
                }

                if ($empresa->getTipoAmbiente() === "2") {
                    if ($empresa->getFechaCaduca() === null) {
                        $empresa->setFechaInicio(new \DateTime());
                        $contratados = $empresa->getCmpContratados() === null ? 0 : $empresa->getCmpContratados();

                        $dias_pago = 30;
                        $fechaActual = new \DateTime();
                        $fechaActual->add(new \DateInterval('P' . $dias_pago . 'D'));
                        $empresa->setFechaCaduca($fechaActual);

                        if ($contratados === -1)
                            $contratados = 0;

                        $empresa->setCmpContratados($contratados);

                    }
                }

                $em->persist($empresa);
                $em->flush();
            }
        }
        return $this->render('Config\electro_settings.html.twig',
            array(
                'form' => $form->createView(),
                'settings' => $data,
            ));
    }

    /**
     * @Route("/smtp_settings", name="smtp_settings")
     *
     */
    public function smtpSettingsAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        if ($empresa != null) {
            //$empresa = new Empresa();
            $data["mailHost"] = $empresa->getMailHost();
            $data["mailPort"] = $empresa->getMailPort();
            $data["mailstartls"] = $empresa->getMailStarttls();
            $data["mailFrom"] = $empresa->getMailfrom();
            $data["passMail"] = $empresa->getPassmail();
            $data["passMailHidden"] = $empresa->getPassmail();

        }

        $form = $this->createForm('App\Form\SmtpSettingsType', $data);

        $form->add('mailStartls', ChoiceType::class, [
            'label' => 'form.smtpssltls',
            'required' => false,
            'choices' => array(
                'form.none' => '',
                'form.ssl' => 'ssl',
                'form.tls' => 'tls',
            ),
            'data' => $empresa->getMailStarttls(),
            'translation_domain' => 'config',
        ]);

        if ($request->getMethod() == 'POST') {
            $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {
                $formData = $form->getData();

                if (empty($formData['passMail'])) {
                    if ($empresa->getPassmail())
                        $formData['passMail'] = $empresa->getPassmail();
                    else
                        unset($formData["passMail"]);
                }

                $empresa = $empresaRepo->setPropertiesSmtpFromArray($formData, $empresa);

                $this->addTranslatedMessage('flash.updated');

                //$this->setEmisorApi($empresa, null, null);

                $app_url = $this->getParameter('api_url');
                $msg = Funciones::setEmisorApi($empresa, null, null, $app_url);
                if($msg !== null)
                    $this->addFlash('danger', $msg);
            }
        }
        return $this->render('Config\smtp_settings.html.twig',
            array(
                'form' => $form->createView(),
                'settings' => $data,
            ));
    }

    /**
     * @Route("/reset_password", name="reset_password")
     *
     */
    public function resetPassAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator, UserPasswordHasherInterface $passwordEncoder)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        //$em = $emFactory->getEm();
        //$empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        //$empresa = $empresaRepo->findOneByUser($user->getRuc());

        //if ($empresa != null) {
            //$empresa = new Empresa();
            //$data["mailHost"] = $empresa->getMailHost();
            //$data["mailPort"] = $empresa->getMailPort();
            //$data["mailstartls"] = $empresa->getMailStarttls();
            //$data["mailFrom"] = $empresa->getMailfrom();
            //$data["passMail"] = $empresa->getPassmail();
            //$data["passMailHidden"] = $empresa->getPassmail();

        //}

        //$form = $this->createForm('App\Form\SmtpSettingsType', $data);

        $form = $this->createForm(ResetPassFormType::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // codificar la contraseña simple
            $user->setPassword($passwordEncoder->hashPassword(
                $user,
                $form->get('plainPassword')->getData()
            ));

            //$entityManager = $this->getDoctrine()->getManager();
            $entityManager = $emFactory->getEmDefault();
            $entityManager->persist($user);
            $entityManager->flush();

            //$this->addFlash('success', "Contraseña actualizada");
            return $this->redirectToRoute('app_logout');
        }

        $errors = $form->getErrors(true);
        //$errors = $errors->get;
        //$form->clearErrors();
        return $this->render('Config\resetpass_settings.html.twig',
            array(
                'form' => $form->createView(),
                'errores ' => $errors
            ));
    }

    /**
     * @Route("/rest/testmail", name="rest_config_testmail")
     */
    public function testMailAction(Request $request, EmFactory $emFactory, ValidatorInterface $validator)
    {
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $data["mailHost"] = $empresa->getMailHost();
        $data["mailPort"] = $empresa->getMailPort();
        $data["mailstartls"] = $empresa->getMailStarttls();
        $data["mailFrom"] = $empresa->getMailfrom();
        $data["passMail"] = $empresa->getPassmail();

        $form = $this->createForm('App\Form\SmtpSettingsType', $data);

        $form->add('mailStartls', ChoiceType::class, [
            'label' => 'form.smtpssltls',
            'required' => false,
            'choices' => array(
                'form.none' => '',
                'form.ssl' => 'ssl',
                'form.tls' => 'tls',
            ),
            'data' => $empresa->getMailStarttls(),
            'translation_domain' => 'config',
        ]);

        $form->handleRequest($request);

        if ($request->getMethod() == 'POST') {
            $formData = $form->getData();

            if (empty($formData['passMail'])) {
                if ($empresa->getPassmail())
                    $formData['passMail'] = $empresa->getPassmail();
            }


            $subject = 'prueba mail';

            //$usuario = new User();
            $mailuser = $formData["mailFrom"];
            $mailpass = $formData['passMail'];
            $mailhost = $formData["mailHost"];
            $mailport = $formData["mailPort"];
            $mailencrypt = $formData["mailstartls"];
            $email = $mailuser;

            if(strcmp($mailhost,"smtp.gmail.com") == 0)
                $mailencrypt = "tls";

            /*$transport = \Swift_SmtpTransport::newInstance()
                ->setHost($mailhost)
                ->setPort($mailport)
                ->setEncryption($mailencrypt)
                ->setUsername($mailuser)
                ->setPassword($mailpass)

            ;

            $mailer = \Swift_Mailer::newInstance($transport);

            $message = \Swift_Message::newInstance()
                ->setSubject($subject)
                ->setFrom($mailuser, $usuario->getName())
                ->setTo($email)
                ->setCc($usuario->getEmail())
                ->setBody($html, 'text/html',  'utf8')
                ->attach($attachmentPdf)
                ->attach($attachmentXml);

            //$message->setCharset('iso-8859-1');

            $headers = "\r\n" . "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=utf8" . "\r\n";

            $result = $mailer->send($message);
            */

            try {
                $transport = new \Swift_SmtpTransport();

                $transport->setAuthMode('login');
                $transport->setHost($mailhost);
                $transport->setPort($mailport);
                $transport->setEncryption($mailencrypt);
                $transport->setUsername($mailuser);
                $transport->setPassword($mailpass);

                $mailer = new \Swift_Mailer($transport);

                $message = new \Swift_Message();
                $message->setCharset('utf8');

                $message->setSubject($subject);
                $message->setFrom($mailuser, $empresa->getNombreComercial());
                $message->setTo($email);
                $message->setCc($empresa->getEmail());
                $message->setBody('prueba mmail', 'text/html');

                $result = $mailer->send($message, $failures);

                return new JsonResponse(array(
                    'message' => 'OK',
                    'result' => $result
                ), 200);
            }
            catch (\Exception $ex){
                return new JsonResponse([$ex->getMessage()], 401);
            }
        }
        return new JsonResponse('ERROR, Desconocido consulte con el administrador ',
            400);
    }

    /**
     * @Route("/transporte_settings", name="transporte_settings")
     *
     */
    public function transporteSettingsAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $transporteSocio = new TransporteSocio();

        if ($empresa != null) {
            //$empresa = new Empresa();

            if ($empresa->getEstransportista()) {
                $transporteSocio = $empresa->getTransportesocio();
            } else {
                $placa = new PlacasSocios();
                $transporteSocio->addPlaca($placa);
            }
        }

        $form = $this->createForm('App\Form\TransporteSettingsType', $transporteSocio, [
            'estransportista' => $empresa->getEstransportista()
        ]);

        if ($request->getMethod() === 'POST') {
            $form->handleRequest($request);
            if ($form->isSubmitted() && $form->isValid()) {
                $formData = $form->getData();

                $transporteSocio->setEmpresa($empresa);
                $em->persist($transporteSocio);
                $empresa->setTransportesocio($transporteSocio);
                $empresa->setEstransportista($transporteSocio->getEstransportista());
                $em->persist($empresa);

                $em->flush();

                $this->addTranslatedMessage('flash.updated');
            }
        }
        return $this->render('Config\transporte_settings.html.twig',
            array(
                'form' => $form->createView(),
                'settings' => $transporteSocio,
            ));
    }

    /**
     * @Route("/rest/partner/caducafirma/{id}", name="retope_partner_caducafirma")
     */
    public function partnerCaducaFirmaAction(EmFactory $emFactory, Request $request, $id, TranslatorInterface $translator)
    {
        $this->translator = $translator;
        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();

        $socio = $em->getRepository('App\Entity\Main\User')->find($id);
        if (!$socio) {
            throw $this->createNotFoundException('Unable to find User entity.');
        }

        $socioauxpass = $socio->getPassword();

        /*** VALIDAR PASSWORD FIRMA ***/

        $app_url = $this->getParameter('api_url');

        $ruc = $socio->getRuc();

        $emisor = new Comprobante($app_url, $ruc, null, null, null, null);

        $error = false;
        $resp = $emisor->validarPasswordFirma($error);

        if ($error) {
            $response = new JsonResponse($error, 202);
            $response->setData(array(
                'error' => true,
                'mensaje' => $resp,
            ));

            return $response;
        }

        $socio->setFechaCaducaFirma($resp->message);

        /*** FIN VALIDAR PASSWORD FIRMA ***/

        if ($socio->getPassword() === null) {
            $socio->setPassword($socioauxpass);
        }

        $em->persist($socio);
        $em->flush();

        $response = new JsonResponse($error, 200);
        $response->setData(array(
            'error' => false,
            'mensaje' => $resp->message,
        ));

        return $response;
    }

    protected function saveLogo(UploadedFile $file, $ruc, LoggerInterface $logger)
    {
        $rutaLogo = null;
        try {
            //$path = $this->getParameter('ruta_documentos');


            if (empty($file)) {
                $this->addTranslatedMessage('Archivo logo no existe', 'warning');
                return null;
            }
            $ext = $file->guessExtension();
            // Move the file to the uploads directory.
            $uploadsDir = "temp/";

            if (!file_exists($uploadsDir)) {
                mkdir($uploadsDir, 0755, true);
            }

            $fileName = "logo_" . $ruc . "." . $ext;

            $newFile = $file->move($uploadsDir, $fileName);

            // Update the property to the new file name.
            $rutaLogo = $uploadsDir . $fileName;
        } catch (\Exception $e) {
            $this->addTranslatedMessage($e->getMessage(), 'danger');
        }
        return $rutaLogo;
    }

    protected function saveFirma(UploadedFile $file, $ruc)
    {
        $rutaFirma = null;
        try {
            if (empty($file)) {
                $this->addTranslatedMessage('Archivo firma no existe', 'warning');
                return null;
            }

            $ext = $file->getClientOriginalName();
            $ext = explode('.', $ext);
            if (strtolower($ext[1]) === 'p12' || strtolower($ext[1]) === 'pfx') {

                // Move the file to the uploads directory.
                $uploadsDir = "temp/";

                if (!file_exists($uploadsDir)) {
                    mkdir($uploadsDir, 0755, true);
                }

                $fileName = $ruc .'.'. $ext[1];

                $newFile = $file->move($uploadsDir, $fileName);
                // Update the property to the new file name.
                $rutaFirma = $uploadsDir . $fileName;

            }
            else{
                $this->addTranslatedMessage('Archivo firma no valido', 'warning');
                return null;
            }


        } catch (\Exception $e) {
            $this->addTranslatedMessage($e->getMessage(), 'danger');
        }
        return $rutaFirma;
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $this->addFlash($status, $this->translator->trans($message, [], 'config'));
    }

    protected function variosEmisorApi(Empresa $empresa, $opcion)
    {

        $app_url = $this->getParameter('api_url');
        $error = false;

        $data = array(
            'opcion' => $opcion
        );

        $json = "";

        try {
            //$serializer = SerializerBuilder::create()->build();
            //$json = $serializer->serialize($data, 'json');
            $json = json_encode($data, JSON_UNESCAPED_UNICODE);
        } catch (\Exception $e) {

        }

        $resp = RestApiFunciones::variosEmisorApi($error, $empresa->getRuc(), $json, $app_url);

        if ($error) {
            $msg = "Error envio servidor api, " . json_encode($resp);
            $this->addFlash('danger', $msg);
            return null;
        }

        if($opcion === 'logo')
            return $resp;

        return null;
    }

    /*protected function setEmisorApi(Empresa $empresa, $ruta_firma, $ruta_logo)
    {

        $app_url = $this->getParameter('api_url');
        $error = false;

        $data = array(
            'razon_social' => $empresa->getRazonSocial(),
            'nombre_comercial' => $empresa->getNombreComercial(),
            'dir_establecimiento' => $empresa->getDirEstablecimiento(),
            'cod_establecimiento' => '000',
            'contribuyente_especial' => $empresa->getContribuyenteEspecial(),
            'lleva_contabilidad' => $empresa->getLlevaContabilidad() === true ? 1 : 0,
            'cod_punto_emision' => '000',
            'tipo_ambiente' => $empresa->getTipoAmbiente() === 1 ? 'PRODUCCION' : 'PRUEBAS',
            'direccion_matriz' => $empresa->getDireccionMatriz(),
            'pass_firma' => $empresa->getPassFirma(),
            'mail_host' => $empresa->getMailHost(),
            'mail_port' => $empresa->getMailPort(),
            'mailfrom' => $empresa->getMailfrom(),
            'passmail' => $empresa->getPassmail(),
            'mail_starttls' => $empresa->getMailStarttls(),
            'emisor_id' => '-1',
            'agente_ret' => $empresa->getAgenteRet() === true ? 1 : 0,
        );

        if($ruta_logo)
            $data['ruta_logo'] = $ruta_logo;
        if($ruta_firma)
            $data['ruta_firma'] = $ruta_firma;

        $json = "";

        try {
            //$serializer = SerializerBuilder::create()->build();
            //$json = $serializer->serialize($data, 'json');
            $json = json_encode($data, JSON_UNESCAPED_UNICODE);
        } catch (\Exception $e) {

        }

        $resp = RestApiFunciones::enviarEmisorApi($error, $empresa->getRuc(), $json, $app_url, $ruta_firma, $ruta_logo);

        if ($error) {
            $msg = "Error envio servidor api, " . json_encode($resp);
            $this->addFlash('danger', $msg);
        } else {
            try {
                unlink($data['ruta_logo']);
            } catch (\Exception $ex) {
            }
            try {
                unlink($data['ruta_firma']);
            } catch (\Exception $ex) {
            }
        }
    }*/
}

