<?php

namespace App\Controller;

use App\Service\EmFactory;
use DateTime;
use Doctrine\ORM\EntityManagerInterface;
use Exception;
use Knp\Component\Pager\PaginatorInterface;
use SoapClient;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;
use XMLWriter;


/**
 * @Route("/descarga")
 */
class DescargaController extends AbstractController
{
    protected  $translator;

    private function microtime_float()
    {
        [$useg, $seg] = explode(" ", microtime());
        return ((float)$useg + (float)$seg);
    }

    /**
     * @Route("/", name="descarga_index")
     *
     */
    public function indexAction(EmFactory $emFactory, Request $request, TranslatorInterface $translator, PaginatorInterface $paginator ): \Symfony\Component\HttpFoundation\Response
    {
        $this->translator= $translator;

        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $repo = $em->getRepository(\App\Entity\Model\Comprobantes::class);
        $repo->setPaginator($paginator);
        // @todo Unhardcode this.
        $limit = 20;

        $upload = $this->createForm(\App\Form\UploadFileSriType::class, null, [
            'action' => $this->generateUrl('descarga_index')
        ]);
        $upload->handleRequest($request);
        if ($upload->isSubmitted() && $upload->isValid()) {
            $tiempo_inicio = new DateTime('now');

            $file = $upload->get('archivosri')->getData();
            //$name = $file->getClientOriginalName();

            $fileName = "descarga_sri." . $file->guessExtension();

            // moves the file to the directory where brochures are stored
            $file->move('uploads/', $fileName);


            $resp = $this->descargarSri('uploads/' . $fileName);

            //$tiempo_fin = new DateTime('now');

            //$segundos = strtotime($tiempo_inicio->format('Y-m-d H:i:s')) - strtotime($tiempo_fin->format('Y-m-d H:i:s'));

            //$this->addTranslatedMessage('Tiempo ejecucion '. $segundos);

            if($resp != null){
                $this->addTranslatedMessage($resp,'danger');

            }
        }

        $form = $this->createForm(\App\Form\SearchDescargaType::class, null, [
            'action' => $this->generateUrl('descarga_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $pagination = $repo->paginatedSearch($form->getData(), $limit, $request->query->getInt('page', 1), $empresa->getId());
        } else {
            $pagination = $repo->paginatedSearch([], $limit, $request->query->getInt('page', 1), $empresa->getId());
        }

        $comprobantes = [];

        foreach ($pagination->getItems() as $item) {
            $aux = [$item];
            $comprobantes[] = $aux[0];
        }

        $listForm = $this->createForm(\App\Form\ListGenericType::class, $comprobantes, [
            'action' => $this->generateUrl('descarga_index'),
        ]);
        $listForm->handleRequest($request);
        if ($listForm->isSubmitted() && $listForm->isValid()) {
            $data = $listForm->getData();
            if ($request->request->has('delete')) {
                if (empty($data['comprobantes'])) {
                    $this->addTranslatedMessage('flash.nothing_selected', 'warning');
                } else {
                    foreach ($data['comprobantes'] as $comprobante) {
                        $em->remove($comprobante);
                    }

                    $em->flush();
                    $this->addTranslatedMessage('flash.bulk_deleted');

                    // Rebuild the query, since some objects are now missing.
                    return $this->redirectToRoute('descarga_index');
                }
            }
        }

        return $this->render('Descarga\index.html.twig',
        [
            'comprobantes' => $pagination,
            //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
            'currency' => $empresa == null ? 'USD':$empresa->getCurrency(),
            'search_form' => $form->createView(),
            'upload_form' => $upload->createView(),
            'list_form' => $listForm->createView(),
        ]);
    }

    /**
     * @Route("descarga_documentos", name="descarga_documentos")
     */
    public function descargaDocumentos(EmFactory $emFactory, Request $request, PaginatorInterface $paginator): \Symfony\Component\HttpFoundation\Response
    {

        $this->denyAccessUnlessGranted('IS_AUTHENTICATED_FULLY');
        $user = $this->getUser();

        $em = $emFactory->getEm();
        $empresaRepo = $em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $repo = $em->getRepository(\App\Entity\Model\Comprobantes::class);
        $repo->setPaginator($paginator);
        // @todo Unhardcode this.
        $limit = $this->getParameter('limit_paginacion');

        $upload = $this->createForm(\App\Form\UploadFileSriType::class, null, [
            'action' => $this->generateUrl('descarga_index')
        ]);

        $form = $this->createForm(\App\Form\SearchDescargaType::class, null, [
            'action' => $this->generateUrl('descarga_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $pagination = $repo->paginatedSearch($form->getData(), $limit, $request->query->getInt('page', 1), $empresa->getId());
        } else {
            $pagination = $repo->paginatedSearch([], $limit, $request->query->getInt('page', 1), $empresa->getId());
        }

        $comprobantes = [];
        foreach ($pagination->getItems() as $item) {
            $aux = [$item];
            $comprobantes[] = $aux[0];
        }

        $listForm = $this->createForm('App\Form\ListDescargaType', $comprobantes, [
            'action' => $this->generateUrl('descarga_index'),
        ]);

        $Name = 'comprobantes.csv';

        $FileName = sprintf('./%s', $Name);
        $Datos = 'razonsocial;fecha;documento;numero;neto;descuento;iva;total';
        $Datos .= "\r\n";

        foreach ($comprobantes as $item)
        {
            //$item = new Comprobantes();
            try {
                $razonsocial = $item->getRazonSocial();
                $fecha= $item->getEmision()->format('d/M/Y');
                $documento = $item->getTipoDoc();
                $numero = $item->getNumero();
                $neto = $item->getNeto();
                $descuento = $item->getTotalDescuento();
                $iva = $item->getIva();
                $total = $item->getTotal();

                $Datos .= sprintf('%s;', $razonsocial) .
                    sprintf('%s;', $fecha) .
                    sprintf('%s;', $documento) .
                    sprintf('%s;', $numero) .
                    sprintf('%s;', $neto) .
                    sprintf('%s;', $descuento) .
                    sprintf('%s;', $iva) .
                    sprintf('%s;', $total);
                $Datos .= "\r\n";

            }catch (Exception $exception) {
                $resp =  $exception->getMessage();
            }
        }

        $em->flush();

        $response = $this->render('Descarga\index.html.twig',
            [
                'comprobantes' => $pagination,
                //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
                'currency' => $empresa == null ? 'USD':$empresa->getCurrency(),
                'search_form' => $form->createView(),
                'upload_form' => $upload->createView(),
                'list_form' => $listForm->createView(),
            ]);

        $response->headers->set('Expires:', '0');
        $response->headers->set('Cache-control:','private');
        $response->headers->set('Cache-Control:','must-revalidate, post-check=0, pre-check=0');
        $response->headers->set('Content-Description:','File Transfer');
        $response->headers->set('Last-Modified:',date('D, d M Y H:i:s'));
        $response->headers->set('Content-Type', 'application/x-octet-stream');
        $response->headers->set('Content-Disposition', 'attachment; filename='.$Name);
        $response->headers->set('Content-Transfer-Encoding:', 'binary');

        $response->sendHeaders();
        $response->setContent($Datos);
        return $response;
    }

    private function descargarSri($pathFile, EntityManagerInterface $entityManager)
    {
        $em = $entityManager;
        $user = $this->getUser();
        $empresa = $user->getEmpresa();
        $respuesta = null;
        try {

            ini_set("soap.wsdl_cache_enabled", "0");

            $wsdl = 'https://cel.sri.gob.ec/comprobantes-electronicos-ws/AutorizacionComprobantes?wsdl';

            $client = new SoapClient($wsdl, ["trace"=>1, "soap_version" => SOAP_1_1, "cache_wsdl" => WSDL_CACHE_MEMORY]);

            ($file = fopen($pathFile, "r")) || exit("Unable to open file!");
            //Output a line of the file until the end is reached
            $i = 0;
            while (!feof($file)) {
                if ($i > 1) {
                    $linea = fgets($file);
                    $items = preg_split('#[\t]#', $linea);
                    if ((is_countable($items) ? count($items) : 0) == 11) {
                        $claveDeAcceso = $items[9];

                        if (strlen($claveDeAcceso) == 49) {
                            $tipoComprobante = substr($claveDeAcceso, 8, 10);
                            $rucTercero = substr($claveDeAcceso, 10, 23);
                            $tipoAmbiente = substr($claveDeAcceso, 23, 24);
                            $numero = substr($claveDeAcceso, 24, 39);

                            $resp = $this->autorizacionIndividual($claveDeAcceso,$client, $empresa);

                            if($resp != null){
                                $respuesta .= $resp.'<br>';
                            }
                        } else {
                            $respuesta .= "NO SE PUDO LOCALIZAR CLAVE ACCESO<br> Error linea texto: ".$linea.'<br>';
                        }
                    }
                }

                ++$i;
            }

            fclose($file);

        } catch (Exception $exception) {
            $respuesta = $exception->getMessage();

        }

        return $respuesta;
    }

    private function autorizacionIndividual($claveAccesoComprobante,$client,$empresa, EntityManagerInterface $entityManager)
    {
        $respuesta = null;
        $em = $entityManager;

        try {
            $param = ['claveAccesoComprobante' => $claveAccesoComprobante];

             //$client->soap_defencoding = 'UTF-8';
            //$client->xml_encoding = 'UTF-8';
            //$client->decode_utf8 = FALSE;

            $response = $client->autorizacionComprobante($param);
            //$response = $client->send($req,'autorizacionComprobante');

            $xml = $response->RespuestaAutorizacionComprobante;

//print_r($resultado);
            $result = $xml->autorizaciones;

            if ($result != null && $result->autorizacion != null) {
                $response = $result->autorizacion;
                if ($response != null) {
                    $estado = $response->estado;
                    if ($estado === 'AUTORIZADO') {

                        $comprobante = new Comprobantes();

                        $numeroAutorizacion = $response->numeroAutorizacion;
                        $fechaAutorizacion = $response->fechaAutorizacion;

                        $comprobante->setNumeroAutorizacion($numeroAutorizacion);
                        $comprobante->setFechaAutorizacion($fechaAutorizacion);


                        $writer = new XMLWriter();
                        //$writer->openURI("newfile.xml");
                        $writer->openMemory();
                        $writer->setIndent(true);
                        $writer->setIndentString("");
                        $writer->startDocument('1.0', 'utf-8', 'yes');

                        $writer->startElement('autorizacion');

                        $writer->startElement("estado");
                        $writer->text($estado);
                        $writer->endElement();

                        $writer->startElement("numeroAutorizacion");
                        $writer->text($numeroAutorizacion);
                        $writer->endElement();

                        $writer->startElement("fechaAutorizacion");
                        $writer->text($fechaAutorizacion);
                        $writer->endElement();

                        $writer->startElement('comprobante');
                        $writer->startCData();
                        $writer->text($response->comprobante);
                        $writer->endCData();
                        $writer->fullEndElement();

                        $writer->startElement("mensajes");
                        //$writer->text("");
                        $writer->endElement();

                        $writer->fullEndElement();

                        $writer->endDocument();
                        $cadenaXML = trim($writer->outputMemory());

                        ($myfile = fopen("uploads/newfile.xml", "w")) || die("Unable to open file!");
                        fwrite($myfile, $cadenaXML);
                        fclose($myfile);

                        $comprobante->cargaXmlString($response->comprobante);
                        $comprobante->setEmpresa($empresa);
                        $comprobante->guardarComprobante();

                        try {
                            $em->persist($comprobante);
                            $em->flush();
                        }catch (Exception $exception)
                        {

                        }

                        //$em->flush();

                    }

                } else {
                    $mensaje = $response->mensajes;
                    if ($mensaje != null) {
                        $msg = $mensaje->mensaje;
                        if ($msg != null) {
                            $respuesta =  $msg->identificador . "   " . $msg->mensaje;
                        }
                    }

                }
            }
        } catch (Exception $exception) {
            $respuesta = $exception->getMessage();
        }

        return $respuesta;
    }

    protected
    function addTranslatedMessage($message, $status = 'success')
    {
        $translator = new Translator('en_EN');

        $this->addFlash($status, $translator->trans($message, [], 'SiwappElectronicosBundle'));
    }

}
