<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 11/09/2017
 * Time: 11:10
 */

namespace App\Electronico\GuiaRemision;


use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class Destinatario
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("identificacionDestinatario")
     * @Serializer\XmlElement(cdata=false)
     */
    private $identificacionDestinatario;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocialDestinatario")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocialDestinatario;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirDestinatario")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirDestinatario;

    /**
     * @Serializer\Type("string")
     * @SerializedName("motivoTraslado")
     * @Serializer\XmlElement(cdata=false)
     */
    private $motivoTraslado;

    /**
     * @Serializer\Type("string")
     * @SerializedName("docAduaneroUnico")
     * @Serializer\XmlElement(cdata=false)
     */
    private $docAduaneroUnico;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codEstabDestino")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codEstabDestino;

    /**
     * @Serializer\Type("string")
     * @SerializedName("ruta")
     * @Serializer\XmlElement(cdata=false)
     */
    private $ruta;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("numDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $numDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("numAutDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $numAutDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmisionDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmisionDocSustento;

    /**
     * @SerializedName("detalles")
     * @XmlList(inline = false, entry = "detalle")
     */
    private $detalles;


    public function __construct()
    {

    }

    /**
     * @return mixed
     */
    public function getIdentificacionDestinatario()
    {
        return $this->identificacionDestinatario;
    }

    /**
     * @param mixed $identificacionDestinatario
     */
    public function setIdentificacionDestinatario($identificacionDestinatario): void
    {
        $this->identificacionDestinatario = $identificacionDestinatario;
    }

    /**
     * @return mixed
     */
    public function getRazonSocialDestinatario()
    {
        return $this->razonSocialDestinatario;
    }

    /**
     * @param mixed $razonSocialDestinatario
     */
    public function setRazonSocialDestinatario($razonSocialDestinatario): void
    {
        $this->razonSocialDestinatario = $razonSocialDestinatario;
    }

    /**
     * @return mixed
     */
    public function getDirDestinatario()
    {
        return $this->dirDestinatario;
    }

    /**
     * @param mixed $dirDestinatario
     */
    public function setDirDestinatario($dirDestinatario): void
    {
        $this->dirDestinatario = $dirDestinatario;
    }

    /**
     * @return mixed
     */
    public function getMotivoTraslado()
    {
        return $this->motivoTraslado;
    }

    /**
     * @param mixed $motivoTraslado
     */
    public function setMotivoTraslado($motivoTraslado): void
    {
        $this->motivoTraslado = $motivoTraslado;
    }

    /**
     * @return mixed
     */
    public function getDocAduaneroUnico()
    {
        return $this->docAduaneroUnico;
    }

    /**
     * @param mixed $docAduaneroUnico
     */
    public function setDocAduaneroUnico($docAduaneroUnico): void
    {
        $this->docAduaneroUnico = $docAduaneroUnico;
    }

    /**
     * @return mixed
     */
    public function getCodEstabDestino()
    {
        return $this->codEstabDestino;
    }

    /**
     * @param mixed $codEstabDestino
     */
    public function setCodEstabDestino($codEstabDestino): void
    {
        $this->codEstabDestino = $codEstabDestino;
    }

    /**
     * @return mixed
     */
    public function getRuta()
    {
        return $this->ruta;
    }

    /**
     * @param mixed $ruta
     */
    public function setRuta($ruta): void
    {
        $this->ruta = $ruta;
    }

    /**
     * @return mixed
     */
    public function getCodDocSustento()
    {
        return $this->codDocSustento;
    }

    /**
     * @param mixed $codDocSustento
     */
    public function setCodDocSustento($codDocSustento): void
    {
        $this->codDocSustento = $codDocSustento;
    }

    /**
     * @return mixed
     */
    public function getNumDocSustento()
    {
        return $this->numDocSustento;
    }

    /**
     * @param mixed $numDocSustento
     */
    public function setNumDocSustento($numDocSustento): void
    {
        $this->numDocSustento = $numDocSustento;
    }

    /**
     * @return mixed
     */
    public function getNumAutDocSustento()
    {
        return $this->numAutDocSustento;
    }

    /**
     * @param mixed $numAutDocSustento
     */
    public function setNumAutDocSustento($numAutDocSustento): void
    {
        $this->numAutDocSustento = $numAutDocSustento;
    }

    /**
     * @return mixed
     */
    public function getFechaEmisionDocSustento()
    {
        return $this->fechaEmisionDocSustento;
    }

    /**
     * @param mixed $fechaEmisionDocSustento
     */
    public function setFechaEmisionDocSustento($fechaEmisionDocSustento): void
    {
        $this->fechaEmisionDocSustento = $fechaEmisionDocSustento;
    }

    /**
     * @return mixed
     */
    public function getDetalles()
    {
        return $this->detalles;
    }

    /**
     * @param mixed $detalles
     */
    public function setDetalles($detalles): void
    {
        $this->detalles = $detalles;
    }


}
