<?php

namespace App\Electronico\LiquidacionCompra;

use App\Electronico\Pago;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;


class InfoLiquidacionCompra
{

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmision")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmision;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirEstablecimiento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirEstablecimiento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("contribuyenteEspecial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $contribuyenteEspecial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("obligadoContabilidad")
     * @Serializer\XmlElement(cdata=false)
     */
    private $obligadoContabilidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoIdentificacionProveedor")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoIdentificacionProveedor;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocialProveedor")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocialProveedor;

    /**
     * @Serializer\Type("string")
     * @SerializedName("identificacionProveedor")
     * @Serializer\XmlElement(cdata=false)
     */
    private $identificacionProveedor;

    /**
     * @Serializer\Type("string")
     * @SerializedName("direccionProveedor")
     * @Serializer\XmlElement(cdata=false)
     */
    private $direccionProveedor;

    /**
     * @Serializer\Type("string")
     * @SerializedName("totalSinImpuestos")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalSinImpuestos;

    /**
     * @Serializer\Type("string")
     * @SerializedName("totalDescuento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalDescuento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("totalComprobantesReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalComprobantesReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("totalBaseImponibleReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalBaseImponibleReembolso;


    /**
     * @Serializer\Type("string")
     * @SerializedName("totalImpuestoReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $totalImpuestoReembolso;


    /**
     * @SerializedName("totalConImpuestos")
     * @XmlList(inline = false, entry = "totalImpuesto")
     */
    private $totalConImpuestos;

    /**
     * @Serializer\Type("string")
     * @SerializedName("importeTotal")
     * @Serializer\XmlElement(cdata=false)
     */
    private $importeTotal;

    /**
     * @Serializer\XmlElement(cdata=false)
     */
    private $moneda = 'DOLAR';

    /**
     * @XmlList(inline = false, entry = "pago")
     */
    private $pagos;

    public function __construct()
    {
        /*$this->propina=number_format(0, 2, '.', '');*/
    }

    /**
     * @return mixed
     */
    public function getFechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * @param mixed $fechaEmision
     */
    public function setFechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
    }

    /**
     * @return mixed
     */
    public function getDirEstablecimiento()
    {
        return $this->dirEstablecimiento;
    }

    /**
     * @param mixed $dirEstablecimiento
     */
    public function setDirEstablecimiento($dirEstablecimiento)
    {
        $this->dirEstablecimiento = $dirEstablecimiento;
    }

    /**
     * @return mixed
     */
    public function getContribuyenteEspecial()
    {
        return $this->contribuyenteEspecial;
    }

    /**
     * @param mixed $contribuyenteEspecial
     */
    public function setContribuyenteEspecial($contribuyenteEspecial)
    {
        $this->contribuyenteEspecial = $contribuyenteEspecial;
    }

    /**
     * @return mixed
     */
    public function getObligadoContabilidad()
    {
        return $this->obligadoContabilidad;
    }

    /**
     * @param mixed $obligadoContabilidad
     */
    public function setObligadoContabilidad(bool  $obligadoContabilidad)
    {
        $this->obligadoContabilidad = $obligadoContabilidad ? 'SI' : 'NO';
    }

    /**
     * @return mixed
     */
    public function getTipoIdentificacionProveedor()
    {
        return $this->tipoIdentificacionProveedor;
    }

    /**
     * @param mixed $tipoIdentificacionProveedor
     */
    public function setTipoIdentificacionProveedor($tipoIdentificacionProveedor)
    {
            $this->tipoIdentificacionProveedor = $tipoIdentificacionProveedor;
     }

    /**
     * @return mixed
     */
    public function getRazonSocialProveedor()
    {
        return $this->razonSocialProveedor;
    }

    /**
     * @param mixed $razonSocialProveedor
     */
    public function setRazonSocialProveedor($razonSocialProveedor)
    {
        $this->razonSocialProveedor = $razonSocialProveedor;
    }

    /**
     * @return mixed
     */
    public function getIdentificacionProveedor()
    {
        return $this->identificacionProveedor;
    }

    /**
     * @param mixed $identificacionProveedor
     */
    public function setIdentificacionProveedor($identificacionProveedor)
    {
        $this->identificacionProveedor = $identificacionProveedor;
    }

    /**
     * @return mixed
     */
    public function getDireccionProveedor()
    {
        return $this->direccionProveedor;
    }

    /**
     * @param mixed $direccionProveedor
     */
    public function setDireccionProveedor($direccionProveedor)
    {
        $this->direccionProveedor = $direccionProveedor;
    }

    /**
     * @return mixed
     */
    public function getTotalSinImpuestos()
    {
        return $this->totalSinImpuestos;
    }

    /**
     * @param mixed $totalSinImpuestos
     */
    public function setTotalSinImpuestos($totalSinImpuestos)
    {
        $this->totalSinImpuestos = number_format($totalSinImpuestos, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getTotalDescuento()
    {
        return $this->totalDescuento;
    }

    /**
     * @param mixed $totalDescuento
     */
    public function setTotalDescuento($totalDescuento)
    {
        $this->totalDescuento = number_format($totalDescuento, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getCodDocReembolso()
    {
        return $this->codDocReembolso;
    }

    /**
     * @param mixed $codDocReembolso
     */
    public function setCodDocReembolso($codDocReembolso): void
    {
        $this->codDocReembolso = $codDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getTotalComprobantesReembolso()
    {
        return $this->totalComprobantesReembolso;
    }

    /**
     * @param mixed $totalComprobantesReembolso
     */
    public function setTotalComprobantesReembolso($totalComprobantesReembolso): void
    {
        $this->totalComprobantesReembolso = $totalComprobantesReembolso;
    }

    /**
     * @return mixed
     */
    public function getTotalBaseImponibleReembolso()
    {
        return $this->totalBaseImponibleReembolso;
    }

    /**
     * @param mixed $totalBaseImponibleReembolso
     */
    public function setTotalBaseImponibleReembolso($totalBaseImponibleReembolso): void
    {
        $this->totalBaseImponibleReembolso = $totalBaseImponibleReembolso;
    }

    /**
     * @return mixed
     */
    public function getTotalImpuestoReembolso()
    {
        return $this->totalImpuestoReembolso;
    }

    /**
     * @param mixed $totalImpuestoReembolso
     */
    public function setTotalImpuestoReembolso($totalImpuestoReembolso): void
    {
        $this->totalImpuestoReembolso = $totalImpuestoReembolso;
    }


    /**
     * @return mixed
     */
    public function getTotalConImpuestos()
    {
        return $this->totalConImpuestos;
    }

    /**
     * @param mixed $totalConImpuestos
     */
    public function setTotalConImpuestos(array  $impuestos)
    {
        $this->totalConImpuestos = $impuestos;
    }

    /**
     * @return mixed
     */
    public function getImporteTotal()
    {
        return $this->importeTotal;
    }

    /**
     * @param mixed $importeTotal
     */
    public function setImporteTotal($importeTotal)
    {
        $this->importeTotal = number_format($importeTotal, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getMoneda()
    {
        return $this->moneda;
    }

    /**
     * @param mixed $moneda
     */
    public function setMoneda($moneda)
    {
        $this->moneda = $moneda;
    }

    /**
     * @return mixed
     */
    public function getPagos()
    {
        return $this->pagos;
    }

    /**
     * @param mixed $pagos
     */
    public function addPagos(Pago $pago)
    {
        $this->pagos[] = $pago;
    }

}

