<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 04/03/2018
 * Time: 20:36
 */

namespace App\Entity\Model;

use App\Electronico\InfoTributaria;
use Doctrine\ORM\Mapping as ORM;
use Exception;
use SimpleXMLElement;
use Siwapp\ElectronicosBundle\Entity\Facturas\InfoFactura;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * App\Entity\Model\Comprobantes
 * @ORM\Table(name="comprobantes", uniqueConstraints={@ORM\UniqueConstraint(name="comprobante_unique", columns={
 *     "claveAcceso",
 *     "empresa_id"
 * })}))
 * @ORM\Entity(repositoryClass="App\Repository\ComprobantesRepository")
 */
class Comprobantes
{
    public  $namespaces;

    /**
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id;

    /**
     * @var string
     * @ORM\Column(name="claveacceso", type="string", length=49)
     */
    private $claveAcceso;

    /**
     * @ORM\Column(name="numero_auto", type="string", length=49)
     */
    private  $numeroAutorizacion;

    /**
     * @ORM\Column(name="fecha_auto", type="string", length=49)
     */
    private  $fechaAutorizacion;

    /**
     * @var text $xml
     *
     * @ORM\Column(name="xml", type="text", nullable=true)
     */
    private $xml = null;

    /**
     * @var date $emision
     *
     * @ORM\Column(name="emision", type="date", nullable=true)
     * @Assert\Date()
     * @Assert\NotBlank()
     */
    private $emision;

    /**
     * @var string
     * @ORM\Column(type="string", length=2)
     */
    private $codDoc;

    /**
     * @var string
     * @ORM\Column(type="string", length=50)
     */
    private $tipoDoc;

    /**
     * @ORM\Column(type="string", length=6)
     */
    private  $serie = null;

    /**
     * @var string
     * @ORM\Column(type="string", length=9)
     */
    private $secuencial;

    /**
     * @var string
     * @ORM\Column(type="string", length=20)
     */
    private $ruc;

    /**
     * @var string
     * @ORM\Column(type="string", length=200)
     */
    private $razonSocial;

    /**
     * @var decimal $baseiva
     *
     * @ORM\Column(name="baseiva", type="decimal", scale=2, precision=15, nullable=true)
     */
    private $baseiva;

    /**
     * @var decimal $basecero
     *
     * @ORM\Column(name="basecero", type="decimal", scale=2, precision=15, nullable=true)
     */
    private $basecero;

    /**
     *
     * @ORM\Column(type="decimal", scale=2, precision=15, nullable=true)
     */
    private $porIva;

    /**
     * @var decimal $totalDescuento
     *
     * @ORM\Column(name="totalDescuento", type="decimal", scale=2, precision=15, nullable=true)
     * @Assert\NotBlank()
     */
    private $totalDescuento;

    /**
     * @var decimal $neto
     *
     * @ORM\Column(name="neto", type="decimal", scale=2, precision=15, nullable=true)
     * @Assert\NotBlank()
     */
    private $neto;

    /**
     * @var decimal $total
     *
     * @ORM\Column(name="total", type="decimal", scale=2, precision=15, nullable=true)
     * @Assert\NotBlank()
     */
    private $total;

    /**
     * @var decimal $iva
     *
     * @ORM\Column(name="iva", type="decimal", scale=2, precision=15, nullable=true)
     * @Assert\NotBlank()
     */
    private $iva;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Empresa")
     * @ORM\JoinColumn(name="empresa_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $empresa;

    /**
     * @return string
     */
    public function getNumeroAutorizacion()
    {
        return $this->numeroAutorizacion;
    }

    /**
     * @param string $numeroAutorizacion
     */
    public function setNumeroAutorizacion($numeroAutorizacion)
    {
        $this->numeroAutorizacion = $numeroAutorizacion;
    }

    /**
     * @return string
     */
    public function getFechaAutorizacion()
    {
        return $this->fechaAutorizacion;
    }

    /**
     * @param string $fechaAutorizacion
     */
    public function setFechaAutorizacion($fechaAutorizacion)
    {
        $this->fechaAutorizacion = $fechaAutorizacion;
    }

    private $infoTributaria;

    private $infoFactura;


    public function __construct()
    {
        $this->emision = new \DateTime();
        $this->infoTributaria = new InfoTributaria();
        $this->infoFactura = new InfoFactura();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getClaveAcceso()
    {
        return $this->claveAcceso;
    }

    /**
     * @param string $claveAcceso
     */
    public function setClaveAcceso($claveAcceso)
    {
        $this->claveAcceso = $claveAcceso;
    }

    /**
     * @return text
     */
    public function getXml()
    {
        return $this->xml;
    }

    /**
     * @param text $xml
     */
    public function setXml($xml)
    {
        $this->xml = $xml;
    }

    /**
     * @return date
     */
    public function getEmision()
    {
        return $this->emision;
    }

    /**
     * @param date $emision
     */
    public function setEmision($emision)
    {
        $this->emision = $emision;
    }

    /**
     * @return string
     */
    public function getSerie()
    {
        return $this->serie;
    }

    /**
     * @param string $serie
     */
    public function setSerie($serie)
    {
        $this->serie = $serie;
    }

    /**
     * @return string
     */
    public function getSecuencial()
    {
        return $this->secuencial;
    }

    /**
     * @return string
     */
    public function getNumero()
    {
        return $this->serie . "-" . $this->secuencial;
    }

    /**
     * @param string $secuencial
     */
    public function setSecuencial($secuencial)
    {
        $this->secuencial = $secuencial;
    }

    /**
     * @return string
     */
    public function getRuc()
    {
        return $this->ruc;
    }

    /**
     * @param string $ruc
     */
    public function setRuc($ruc)
    {
        $this->ruc = $ruc;
    }

    /**
     * @return string
     */
    public function getRazonSocial()
    {
        return $this->razonSocial;
    }

    /**
     * @param string $razonSocial
     */
    public function setRazonSocial($razonSocial)
    {
        $this->razonSocial = $razonSocial;
    }

    /**
     * @return decimal
     */
    public function getBaseiva()
    {
        return $this->baseiva;
    }

    /**
     * @param decimal $baseiva
     */
    public function setBaseiva($baseiva)
    {
        $this->baseiva = $baseiva;
    }

    /**
     * @return decimal
     */
    public function getBasecero()
    {
        return $this->basecero;
    }

    /**
     * @param decimal $basecero
     */
    public function setBasecero($basecero)
    {
        $this->basecero = $basecero;
    }

    /**
     * @return mixed
     */
    public function getPorIva()
    {
        return $this->porIva;
    }

    /**
     * @param mixed $porIva
     */
    public function setPorIva($porIva)
    {
        $this->porIva = $porIva;
    }

    /**
     * @return decimal
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @param decimal $total
     */
    public function setTotal($total)
    {
        $this->total = $total;
    }

    /**
     * @return string
     */
    public function getCodDoc()
    {
        return $this->codDoc;
    }

    /**
     * @param string $codDoc
     */
    public function setCodDoc($codDoc)
    {
        $this->codDoc = $codDoc;
    }

    /**
     * @return decimal
     */
    public function getTotalDescuento()
    {
        return $this->totalDescuento;
    }

    /**
     * @param decimal $totalDescuento
     */
    public function setTotalDescuento($totalDescuento)
    {
        $this->totalDescuento = $totalDescuento;
    }

    /**
     * @return decimal
     */
    public function getNeto()
    {
        return $this->neto;
    }

    /**
     * @param decimal $neto
     */
    public function setNeto($neto)
    {
        $this->neto = $neto;
    }

    /**
     * @return decimal
     */
    public function getIva()
    {
        return $this->iva;
    }

    /**
     * @param decimal $iva
     */
    public function setIva($iva)
    {
        $this->iva = $iva;
    }

    /**
     * @return string
     */
    public function getTipoDoc()
    {
        return $this->tipoDoc;
    }

    /**
     * @param string $tipoDoc
     */
    public function setTipoDoc($tipoDoc)
    {
        $this->tipoDoc = $tipoDoc;
    }

    /**
     * @return mixed
     */
    public function getEmpresa()
    {
        return $this->empresa;
    }

    /**
     * @param mixed $empresa
     */
    public function setEmpresa($empresa)
    {
        $this->empresa = $empresa;
    }


    public function jsonSerialize()
    {
        return [
            'id' => $this->getId(),

        ];
    }

    public function guardarComprobante()
    {
        try {
            $this->claveAcceso = $this->infoTributaria->getClaveAcceso();
            $this->ruc = $this->infoTributaria->getRuc();
            $this->razonSocial = $this->infoTributaria->getRazonSocial();
            $this->serie = $this->infoTributaria->getEstab() . $this->infoTributaria->getPtoEmi();
            $this->secuencial = $this->infoTributaria->getSecuencial();
            $this->codDoc = $this->infoTributaria->getCodDoc();
            $this->tipoDoc = $this->tipoDocumento($this->codDoc);

            $anio = substr($this->claveAcceso, 4, 4);
            $mes = substr($this->claveAcceso, 2, 2);
            $dia = substr($this->claveAcceso, 0, 2);
            $this->emision = new \DateTime($anio.$mes.$dia);

            $this->totalDescuento = $this->infoFactura->getTotalDescuento();
            $this->total = $this->infoFactura->getImporteTotal();
            $this->neto = $this->infoFactura->getTotalSinImpuestos();
        } catch (Exception $exception) {
            echo $exception->getMessage();
        }

    }

    public function tipoDocumento($codDoc){

        switch ($codDoc){
            case '01':
                return 'Factura';
                break;
            case '04':
                return 'N. Crédito';
                break;
            case '07':
                return 'Retención';
                break;
            case '06':
                return 'G. Remisión';
                break;
        }

    }

    /**
     * archivoXML Ruta del archivo XML
     */
    function cargaXml($archivoXML)
    {

        if (file_exists($archivoXML)) {
            libxml_use_internal_errors(true);
            $this->xml = new SimpleXMLElement($archivoXML, null, true);
            $this->namespaces = $this->xml->getNamespaces(true);
        } else {
            throw new Exception("Error al cargar archivo XML, verifique que el archivo exista.", 1);
        }

    }

    /**
     * archivoXML Ruta del archivo XML
     */
    function cargaXmlString($cadenaXML)
    {
        $this->xml = simplexml_load_string($cadenaXML);
        libxml_use_internal_errors(true);

        $this->cargarInfoTributaria();

        if ($this->infoTributaria->getCodDoc() == "01") {

            $this->cargarInfoFactura();
        }
    }

    /**
     * Obtener el RFC del Empresa
     */
    private function cargarInfoTributaria()
    {
        foreach ($this->xml->xpath('//infoTributaria') as $empresa) {
            $this->infoTributaria->setAmbiente((string)$empresa->ambiente);
            $this->infoTributaria->setRazonSocial((string)$empresa->razonSocial);
            $this->infoTributaria->setNombreComercial((string)$empresa->nombreComercial);
            $this->infoTributaria->setRuc((string)$empresa->ruc);
            $this->infoTributaria->setEstab((string)$empresa->estab);
            $this->infoTributaria->setPtoEmi((string)$empresa->ptoEmi);
            $this->infoTributaria->setSecuencial((string)$empresa->secuencial);
            $this->infoTributaria->setCodDoc((string)$empresa->codDoc);
            $this->infoTributaria->setClaveAcceso((string)$empresa->claveAcceso);

        }
    }

    /**
     * Obtener el RFC del Empresa
     */
    private function cargarInfoFactura()
    {
        try {
            foreach ($this->xml->xpath('//infoFactura') as $factura) {
                //$this->infoFactura->setFechaEmision((string)$factura->fechaEmision);
                $this->infoFactura->setTotalSinImpuestos((string)$factura->totalSinImpuestos);
                $this->infoFactura->setTotalDescuento((string)$factura->totalDescuento);
                $this->infoFactura->setImporteTotal((string)$factura->importeTotal);
            }
        } catch (Exception $exception) {
            echo $exception->getMessage();
        }

    }

    /**
     * Obtener el RFC del Empresa
     */
    private function cargarInfoRetencion()
    {
        try {
            foreach ($this->xml->xpath('//infoFactura') as $factura) {
                //$this->infoFactura->setFechaEmision((string)$factura->fechaEmision);
                $this->infoFactura->setTotalSinImpuestos((string)$factura->totalSinImpuestos);
                $this->infoFactura->setTotalDescuento((string)$factura->totalDescuento);
                $this->infoFactura->setImporteTotal((string)$factura->importeTotal);
            }
        } catch (Exception $exception) {
            echo $exception->getMessage();
        }

    }

    /**
     * Obtener el RFC del Receptor
     */
    /*function rfcReceptor()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante//cfdi:Receptor') as $receptor) {
            $this->rfcReceptor = $receptor['rfc'] != "" ? $receptor['rfc'] : $receptor['Rfc'];
        }

        return $this->rfcReceptor;
    }

    /**
     * Obtener el RFC  del CFDI
     */
    /*function total()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante') as $comprobante) {
            $this->total = $comprobante['total'] != "" ? $comprobante['total'] : $comprobante['Total'];
        }
        return $this->total;
    }

    /**
     * Obtener la serie del CFDI
     */
    /*function serie()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante') as $comprobante) {
            $this->serie = $comprobante['serie'] != "" ? $comprobante['serie'] : $comprobante['Serie'];
        }

        return $this->serie;
    }

    /**
     * Obtener elfolio del CFDI
     */
    /*function folio()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante') as $comprobante) {
            $this->folio = $comprobante['folio'] != "" ? $comprobante['folio'] : $comprobante['Folio'];
        }

        return $this->folio;
    }

    /**
     * Obtener el la fecha del CFDI
     */
    /*function fecha()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante') as $comprobante) {
            $this->fecha = $comprobante['fecha'] != "" ? $comprobante['fecha'] : $comprobante['Fecha'];
        }

        return $this->fecha;
    }

    /**
     * Obtener el tipo del comprobante del  CFDI (Ingreso o Egreso);
     */
    /*function tipoComprobante()
    {

        foreach ($this->xml->xpath('//cfdi:Comprobante') as $comprobante) {
            $this->tipoComprobante = $comprobante['tipoDeComprobante'] != "" ? $comprobante['tipoDeComprobante'] : $comprobante['TipoDeComprobante'];
        }

        if (strcmp(strtolower($this->tipoComprobante), 'ingreso') == 0 || strcmp(strtolower($this->tipoComprobante), 'i') == 0) {
            $this->tipoComprobante = "I";
        } else {
            $this->tipoComprobante = "E";
        }

        return $this->tipoComprobante;
    }
    */


}
