<?php

namespace App\Form\Admin;

use App\Entity\Model\Empresa;
use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemEmpresaContadorType extends AbstractType
{
    private $manager;
    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        //$currency = $this->manager->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR');

        $builder->add('empresa', EntityType::class, array(
            'class' => 'App\Entity\Model\Empresa',
            'choice_label' => function (Empresa $item, $key, $index) {
                $len =strlen($item->getRazonSocial());
                $nombre = $item->getRazonSocial();
                if ($len > 100){
                    $nombre = substr($item->getRazonSocial(),0,100)."...";
                }
                return $nombre;
            },
            'choice_value' => function (Empresa $entity = null) {
                return $entity ? $entity->getId() : '';
            },
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('t')
                    ->addOrderBy('t.razonSocial', 'ASC');

            },
            'multiple' => false,
            'required' => false,
        ));

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Model\ItemEmpresaContador',
        ]);
    }
}
