<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GlobalSettingsType extends AbstractType
{
    protected static $paper_sizes = ["4a0" => "4A0", "2a0" => "2A0", "a0" => "A0", "a1" => "A1", "a2" => "A2", "a3" => "A3", "a4" => "A4", "a5" => "A5", "a6" => "A6", "a7" => "A7", "a8" => "A8", "a9" => "A9", "a10" => "A10", "b0" => "B0", "b1" => "B1", "b2" => "B2", "b3" => "B3", "b4" => "B4", "b5" => "B5", "b6" => "B6", "b7" => "B7", "b8" => "B8", "b9" => "B9", "b10" => "B10", "c0" => "C0", "c1" => "C1", "c2" => "C2", "c3" => "C3", "c4" => "C4", "c5" => "C5", "c6" => "C6", "c7" => "C7", "c8" => "C8", "c9" => "C9", "c10" => "C10", "ra0" => "RA0", "ra1" => "RA1", "ra2" => "RA2", "ra3" => "RA3", "ra4" => "RA4", "sra0" => "SRA0", "sra1" => "SRA1", "sra2" => "SRA2", "sra3" => "SRA3", "sra4" => "SRA4", "letter" => "Letter", "legal" => "Legal", "ledger" => "Ledger", "tabloid" => "Tabloid", "executive" => "Executive", "folio" => "Folio", "commerical #10 envelope" => "Commercial #10 Envelope", "catalog #10 1/2 envelope" => "Catalog #10 1/2 Envelope", "8.5x11" => "8.5x11", "8.5x14" => "8.5x14", "11x17" => "11x17"];

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('razonSocial', TextType::class, [
                'required' => true,
                'label' => 'form.company_name',
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'translation_domain' => 'config',

            ])
            ->add('nombreComercial', TextType::class, [
                'required' => false,
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'label' => 'form.company_nameComercial',
                'translation_domain' => 'config',

            ])
            ->add('ruc', TextType::class, [
                'required' => true,
                'attr' => ['readonly'=>'readonly', 'autocomplete' => 'off'],
                'label' => 'form.company_identification',
                'translation_domain' => 'config',
            ])
            ->add('dirEstablecimiento', TextType::class, [
                'required' => true,
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'label' => 'Dirección Establecimiento',
                'translation_domain' => 'config',
            ])
            ->add('direccionMatriz', TextType::class, [
                'required' => true,
                'attr' => ['class'=>'sv_uppercase'],
                'label' => 'Dirección Matriz',
                'translation_domain' => 'config',
            ])
            ->add('telefono', TextType::class, [
                'required' => true,
                'label' => 'form.company_phone',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('email', EmailType::class, [
                'label' => 'form.company_email',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            /*->add('url', UrlType::class, [
                'required' => false,
                'label' => 'form.company_url',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])*/
            ->add('rutaLogo', FileType::class, [
                'required' => false,
                'label' => 'form.company_logo',
                'row_attr' =>['id'=>'demo'],
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])

            ->add('decPunit', NumberType::class, [
                'scale' => 0,
                'required' => true,
                'grouping' => true,
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)", 'min'=>'0', 'max'=>'4', 'autocomplete' => 'off'],
                'label' => 'Dec. Precio',
                //'translation_domain' => 'config',
            ])

        ;

        $builder->get('rutaLogo')
            ->addModelTransformer(new CallbackTransformer(
                static function ($filename) {
                    return $filename ? new File($filename, false) : null;
                },

                static function ($file) {
                    return $file;
                }
            ));

        $builder->add('taxes', CollectionType::class, ['label' => 'form.taxes', 'translation_domain' => 'config', 'entry_type' => \App\Form\TaxType::class, 'allow_add' => true, 'allow_delete' => true, 'prototype' => true, 'entry_options' => ['label' => false]]);

        $builder->add('series', CollectionType::class, ['label' => 'form.series', 'translation_domain' => 'config', 'entry_type' => \App\Form\SeriesType::class, 'allow_add' => true, 'allow_delete' => true, 'prototype' => true, 'entry_options' => ['label' => false]]);
    }
}
