<?php

namespace App\Form;

use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemGuiaType extends AbstractType
{
    private $manager;

    private $security;

    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        //$currency = $this->manager->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR');
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            //->add('product', TextType::class, ['required' => false])
            ->add('quantity', NumberType::class, [
                'attr' => ['class' => 'svtext-right', 'autocomplete' => 'off', 'onkeypress' => "return filterFloat(event,this)"]
            ])
            ->add('description', TextType::class, [
                'attr' => [
                    'class' => 'svtext-right', 'autocomplete' => 'off',
                ]])
            ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\ItemGuia::class
        ]);
    }
}
