<?php

namespace App\Form;

use App\Entity\Model\ItemPago;
use App\Entity\Model\Liquidacion;
use App\Entity\Model\Reembolso;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\OptionsResolver\OptionsResolver;


class LiquidacionType extends AbstractLiquidacionType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);

        $newPago = new ItemPago();
        $builder->add('pagos', CollectionType::class, ['entry_type' => \App\Form\ItemPagoType::class, 'allow_add' => true, 'allow_delete' => true, 'prototype' => true, 'by_reference' => false, 'label' => false, 'prototype_data' => $newPago]);

        /*->add('due_date', DateType::class, [
                'widget' => 'single_text',
                'label' => 'form.due_date',
                'translation_domain' => 'liquidacion',
            ])
            ->add('forcefully_closed', null, [
                'label' => 'form.forcefully_closed',
                'translation_domain' => 'liquidacion',
            ])
            ->add('sent_by_email', null, [
                'label' => 'form.sent_by_email',
                'translation_domain' => 'liquidacion',
            ])
            */;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Liquidacion::class,
        ]);
    }
}
