<?php

namespace App\Form;

use App\Service\EmFactory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ProductType extends AbstractType
{
    private $manager;

    private $security;

    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            ->add('reference', null, [
                'label' => 'form.reference',
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'translation_domain' => 'product',
            ])
            ->add('description', null, [
                'label' => 'form.description',
                'attr' => ['class'=>'sv_uppercase', 'autocomplete' => 'off'],
                'translation_domain' => 'product',
            ])
            ->add('price', NumberType::class, [
                'label' => 'form.price',
                'scale' => $this->empresa->getDecPunit(),
                'grouping' => true,
                'translation_domain' => 'product',
                //'attr' => ['class'=>'floatTextBox svtext-right']
                'attr' => ['class' => 'svtext-right', 'autocomplete' => 'off', 'onkeypress'=>"return filterFloat(event,this)"]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Product::class,
        ]);
    }
}
