<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;


class SearchDescargaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('claveAcceso', null, [
                'required' => false,
                'label' => 'Clave Acceso',
            ])
            /*->add('status', ChoiceType::class, [
                'label' => 'search.status',
                'translation_domain' => 'SiwappInvoiceBundle',
                'choices' => [
                    'invoice.draft' => Invoice::DRAFT,
                    'invoice.opened' => Invoice::OPENED,
                    'invoice.overdue' => Invoice::OVERDUE,
                    'invoice.closed' => Invoice::CLOSED,
                ],
                'required' => false,
            ])
            */
            ->add('date_from', DateType::class, [
                'label' => 'Desde',
                'translation_domain' => 'SiwappInvoiceBundle',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('date_to', DateType::class, [
                'label' => 'Hasta',
                'translation_domain' => 'SiwappInvoiceBundle',
                'widget' => 'single_text',
                'required' => false,
            ])
        ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(['csrf_protection' => false]);
    }
}
