<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SmtpSettingsType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('mailHost', TextType::class, [
                'required' => true,
                'label' => 'form.smtphost',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('mailPort', TextType::class, [
                'required' => true,
                'attr' => ['maxlength' => 3, 'autocomplete' => 'off'],
                'label' => 'form.smtpport',
                'translation_domain' => 'config',
            ])
            ->add('mailFrom', TextType::class, [
                'required' => true,
                'label' => 'form.smtpcuenta',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('passMail', PasswordType::class, [
                'required' => false,
                'label' => 'form.smtppass',
                'translation_domain' => 'config',
                'attr' => ['autocomplete' => 'off'],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'attr' => ['id' => 'smtp_settingssv'],
        ]);
    }

}
