<?php

namespace App\Repository;

use App\Entity\Model\Empresa;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
//use Doctrine\Common\Persistence\ManagerRegistry;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\ORM\NonUniqueResultException;
use Knp\Component\Pager\PaginatorInterface;

/**
 * @method Empresa|null find($id, $lockMode = null, $lockVersion = null)
 * @method Empresa|null findOneBy(array $criteria, array $orderBy = null)
 * @method Empresa[]    findAll()
 * @method Empresa[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EmpresaRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Empresa::class);
    }

    public function paginatedSearch(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Empresa::class, 'c')
            ->orderBy('c.id')
        ;

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $terms = $qb->expr()->literal("%$value%");
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('c.razonSocial', $terms),
                    $qb->expr()->like('c.ruc', $terms)
                ));
            }
        }


        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

    public function findOneByUser(string $value): ?Empresa
    {
        try {
            return $this->createQueryBuilder('f')
                ->where('f.ruc = :val')
                ->setParameter('val', $value)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function findOneByUserTransportista(string $value): ?Empresa
    {
        try {
            return $this->createQueryBuilder('f')
                ->where('f.ruc = :val')
                ->andWhere('f.estransportista = true')
                ->setParameter('val', $value)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    /**
     * Saves an associative array as properties
     *
     * @return void
     *
     */
    public function setPropertiesFromArray($data, Empresa $empresa): ?Empresa
    {
        /*foreach ($data as $k => $v) {
            $property = $this->setProperty($k, $v);
            $em->persist($property);
        }*/

        $empresa->setRazonSocial($data["razonSocial"]);
        $empresa->setRuc($data["ruc"]);
        $empresa->setDirEstablecimiento($data["dirEstablecimiento"]);
        $empresa->setTelefono($data["telefono"]);
        $empresa->setEmail($data["email"]);
        $empresa->setUrl($data["url"] === null ? "" : $data["url"]);
        $empresa->setNombreComercial($data["nombreComercial"] === null ? "" : $data["nombreComercial"]);
        $empresa->setDireccionMatriz($data["direccionMatriz"]);
        $empresa->setCurrency("USD");

        if (!empty($data['rutaLogo']))
            $empresa->setRutaLogo($data["rutaLogo"]);
        else
            $empresa->setRutaLogo(null);

        if (!empty($data['decPunit']))
            $empresa->setDecPunit($data["decPunit"]);

        $em = $this->getEntityManager();
        $em->persist($empresa);
        $em->flush();

        return $empresa;
    }

    public function setPropertiesElectroFromArray($data, Empresa $empresa):?Empresa
    {
        /*foreach ($data as $k => $v) {
            $property = $this->setProperty($k, $v);
            $em->persist($property);
        }*/

        if (!empty($data['rutaFirma']))
            $empresa->setRutaFirma($data["rutaFirma"]);
        else
            $empresa->setRutaFirma(null);

        $empresa->setTipoAmbiente($data["tipoAmbiente"] === null ? "1" : $data["tipoAmbiente"]);
        $empresa->setLlevaContabilidad($data["llevaContabilidad"] === null ? false : $data["llevaContabilidad"]);

        if (!empty($data['passFirma']))
            $empresa->setPassFirma($data["passFirma"] === null ? "" : $data["passFirma"]);
        else
            $empresa->setPassFirma(null);

        $empresa->setContribuyenteEspecial($data["contribuyenteEspecial"] === null ? "" : $data["contribuyenteEspecial"]);

        $empresa->setAgenteRet($data["agenteRet"] === null ? "" : $data["agenteRet"]);

        if(isset($data["envioAutomatico"]))
            $empresa->setEnvioAutomatico($data["envioAutomatico"]);
        else
            $empresa->setEnvioAutomatico(false);

        if(isset($data["envioMailAutomatico"]))
            $empresa->setEnvioMailAutomatico($data["envioMailAutomatico"]);
        else
            $empresa->setEnvioMailAutomatico(false);


        $empresa->setRimpe(false);
        $empresa->setNegpopular(false);
        if(isset($data["rimpe"])) {
            if ($data['rimpe'] === 3)
                $empresa->setRimpe(true);
            elseif ($data['rimpe'] === 4)
                $empresa->setNegpopular(true);

        }

        $em = $this->getEntityManager();
        $em->persist($empresa);
        $em->flush();

        return $empresa;

    }

    public function setPropertiesSmtpFromArray($data, Empresa $empresa):?Empresa
    {
        $empresa->setMailHost($data["mailHost"] === null ? "" : $data["mailHost"]);
        $empresa->setMailPort($data["mailPort"] === null ? "" : $data["mailPort"]);
        $empresa->setMailStarttls($data["mailStartls"] === null ? "" : $data["mailStartls"]);

        $empresa->setMailfrom($data["mailFrom"] === null ? "" : $data["mailFrom"]);
        $empresa->setPassmail($data["passMail"] === null ? "" : $data["passMail"]);

        $em = $this->getEntityManager();
        $em->persist($empresa);
        $em->flush();

        return  $empresa;
    }

}
