<?php

namespace App\Repository;

use App\Entity\Model\Item;
use App\Entity\Model\Series;
use App\Entity\Model\Tax;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NonUniqueResultException;

/**
 * ItemRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ItemRepository extends EntityRepository
{
    public function findLikeDescription(string $term, $empresa_id): array
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('i')
            ->from(Item::class, 'i')
            //->where('i.product.empresa = :empresa_id')
            ->orWhere('i.description LIKE :term')
            ->setParameter('term', '%'. $term .'%')
            //->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function findTaxDefault($empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Tax::class, 'c')
            ->Where('c.is_default = true')
            ->andWhere('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getSingleResult();
    }

    public function findTaxPorcentaje($valor, $empresa_id)
    {
        try {
            $resp = $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Tax::class, 'c')
                ->Where('c.value = :valor')
                ->andWhere('c.empresa = :empresa_id')
                ->setParameter('empresa_id', $empresa_id)
                ->setParameter('valor', $valor)
                ->getQuery()
                ->getOneOrNullResult();

            return $resp;
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    /*

    public function findDefault()
    {
        $resp = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Tax::class, 'c')
            ->Where('c.is_default = true')
            ->getQuery()
            ->getSingleResult();
        return $resp;
    }
*/
    public function findTaxesEmpresa($empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Tax::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function findSeriesEmpresa($empresa_id)
    {
        return $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Series::class, 'c')
            ->where('c.empresa = :empresa_id')
            ->setParameter('empresa_id', $empresa_id)
            ->getQuery()
            ->getResult();
    }

    public function findIdTaxesEmpresaPorcentaje($empresa_id, $porcentaje): ?Tax
    {

        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Tax::class, 'c')
                ->where('c.empresa = :empresa_id')
                ->andWhere('c.value = :porcentaje')
                ->setParameter('empresa_id', $empresa_id)
                ->setParameter('porcentaje', $porcentaje)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $nonUniqueResultException) {
            return null;
        }
    }
}
