<?php

namespace App\Repository;

use App\Entity\Model\Planes;
use Doctrine\ORM\NonUniqueResultException;
use Knp\Component\Pager\PaginatorInterface;

/**
 * ItemRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PlanesRepository extends \Doctrine\ORM\EntityRepository
{
    public function findTodos()
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Planes::class, 'c')
                ->orderBy('c.orden','asc')
                ->getQuery()
                ->getResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }
    public function findById(string $id) : ?Planes
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Planes::class, 'c')
                ->Where("c.id = :id")
                ->setParameter('id', $id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function findByCodigo($empresa_id, string $codigo): ?Planes
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Planes::class, 'c')
                ->Where("c.cta_codigo = :codigo")
                ->setParameter('codigo', $codigo)
                ->setParameter('empresa_id', $empresa_id)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }
    public function findByIlimitado()
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Planes::class, 'c')
                ->Where("c.ilimitado = 1")
                ->getQuery()
                ->getResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function findByIlimitadEdit($id)
    {
        try {
            return $this->getEntityManager()
                ->createQueryBuilder()
                ->select('c')
                ->from(Planes::class, 'c')
                ->Where("c.ilimitado = 1")
                ->andWhere("c.id <> $id")
                ->getQuery()
                ->getResult();
        } catch (NonUniqueResultException $e) {
            return null;
        }
    }

    public function paginatedSearch(array $params, $limit = 50, $page = 1)
    {
        if (!$this->paginator) {
            throw new \RuntimeException('You have to set a paginator.yaml first using setPaginator() method');
        }

        $qb = $this->getEntityManager()
            ->createQueryBuilder()
            ->select('c')
            ->from(Planes::class, 'c');

        foreach ($params as $field => $value) {
            if ($value === null) {
                continue;
            }
            if ($field == 'terms') {
                $terms = $qb->expr()->literal("%$value%");
                $qb->andWhere($qb->expr()->orX(
                    $qb->expr()->like('c.name', $terms)
                ));
            }
        }


        return $this->paginator->paginate($qb->getQuery(), $page, $limit);
    }

    /**
     * There is no easy way to inject things into repositories yet.
     */
    public function setPaginator(PaginatorInterface $paginator)
    {
        $this->paginator = $paginator;
    }

}
