<?php


namespace App\Util;

use App\Entity\Model\Empresa;
use App\Entity\Model\TransporteSocio;
use App\Entity\Model\User;
use Doctrine\ORM\EntityManagerInterface;
use PDO;
use DateTime;
use PDOException;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

class Funciones
{
    public static function setNuevaEmpresaTransportista(TransporteSocio $transportista, EntityManagerInterface $em)
    {
        $socio = new Empresa();
        //$user = new User();
        $socio->setRuc($transportista->getRucsocio());
        $socio->setEmail($transportista->getEmail());
        $socio->setRazonSocial($transportista->getNombresocio());
        $socio->setDirEstablecimiento("Dirección Establecimiento");
        $socio->setDireccionMatriz("Direccion Matriz");
        $socio->setTelefono("000");
        $socio->setCurrency("USD");
        $socio->setTipoAmbiente("1");
        $DatetimeFechaActual = new \DateTime("now");
        $DatetimeFechaActual->add(new \DateInterval('P1Y'));
        $socio->setFechaCaducaFirma($DatetimeFechaActual);

        /*$socio->setMailHost($puntero->getParameter('mail_host'));
        $socio->setMailPort($puntero->getParameter('mail_port'));
        $socio->setMailStarttls($puntero->getParameter('mail_tls'));
        $socio->setMailfrom($puntero->getParameter('mail_from'));
        $socio->setPassmail($puntero->getParameter('mail_pass'));*/

        $socio->setEstransportista(true);

        /*$em->persist($socio);
        $em->flush();

        $data["razonSocial"] = $socio->getRazonSocial();
        $data["ruc"] = $socio->getRuc();
        $data["dirEstablecimiento"] = $socio->getDirEstablecimiento();
        $data["telefono"] = $socio->getTelefono();
        $data["email"] = $socio->getEmail();
        $data["url"] = $socio->getUrl();
        $data["rutaLogo"] = $socio->getRutaLogo();
        $data["nombreComercial"] = $socio->getNombreComercial();
        $data["decPunit"] = $socio->getDecPunit();

        $consfinal = new Customer();
        $consfinal->setEmpresa($socio);
        $consfinal->setEmail($socio->getEmail());
        $consfinal->setName('CONSUMIDOR FINAL');
        $consfinal->setInvoicingAddress('S/N');
        $consfinal->setTipoDocumento('07');
        $consfinal->setTelefono('000');
        $consfinal->setIdentification('9999999999999');

        $em->persist($consfinal);

        $serie = new Series();
        $serie->setName("MATRIZ");
        $serie->setValue("001100");
        $serie->setIniFactura(1);
        $serie->setIniRetencion(1);
        $serie->setIniCredito(1);
        $serie->setIniLiquidacion(1);
        $serie->setIniDebito(1);
        $serie->setEnabled(true);
        $serie->setEmpresa($socio);

        $em->persist($serie);

        $tax = new Tax();
        $tax->setName("IVA 12");
        $tax->setValue(12);
        $tax->setActive(true);
        $tax->setIsDefault(true);
        $tax->setEmpresa($socio);

        $em->persist($tax);

        $tax = new Tax();
        $tax->setName("IVA 0");
        $tax->setValue(0);
        $tax->setActive(false);
        $tax->setIsDefault(false);
        $tax->setEmpresa($socio);

        $em->persist($tax);

        $em->flush();*/

        return $socio;
    }

    public static function setUpdateEmpresaTransportista(Empresa $socio, TransporteSocio $transportista)
    {
        //$user = new User();
        $socio->setRuc($transportista->getRucsocio());
        $socio->setEmail($transportista->getEmail());
        $socio->setRazonSocial($transportista->getNombresocio());

        $socio->setEstransportista(true);

        return $socio;
    }

    public static function getPdf(&$error, $app_url, $clave, $xml, &$mensaje, $print = false)
    {
        // get cURL resource
        $ch = curl_init();
        $response = null;
        try {

            // set url
            curl_setopt($ch, CURLOPT_URL, $app_url);

            // set method
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');

            // return the transfer as a string
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            // set headers
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                //'Cookie: XSRF-TOKEN=eyJpdiI6Ilo3bk1FYVF5emtjVTNZT1lmTEFPS0E9PSIsInZhbHVlIjoiTFh6RkFGeVdZU1A2S2tOTUo1bEhOVFlLT1NobnZYVDlneHFDWEI0Rk9xUk9yelhzM0t6YmJqelBPYlY3NnZlUCIsIm1hYyI6IjA3YzJhNGQyMTJlNDYyMjE5YTg0OTM0YTQ2M2RlNzFhOGU3NGEyOTk1NjQ3Yjg2NGJjNmIzYzFkYTJlOGQzOWQifQ%3D%3D; laravel_session=eyJpdiI6IjhRYzZ1NmJXcWpZSkNOQjBOWXNJd0E9PSIsInZhbHVlIjoidmorNUxyUnFmNGRpRFlmZ3YzQTR6ZUpFUWNwbnhBODFpVGhKVkVXRWg3dGZ0dnFjc3Y2d2NyN1VOU0I5ZjRRMSIsIm1hYyI6IjIwYWYwZTlkYzFkZWM5NjY0NDNjZGUxNzdiZmYxYjBiMzBiYTY2ZDVkYzU1ZDgwMDIwZjlmZmViZjNjNDFhNzIifQ%3D%3D',
                'Authorization: sHaRa150108&X' . $clave,
                'Content-Type: multipart/form-data',  //  IMPORTANTE NO OLVIDAR
                'Accept: application/octet-stream',
            ]);

            // form body
            $body = [
                'cadena' => base64_encode(utf8_encode($xml)),
                'offline' => true,
                'print' => $print
            ];
            //$body = http_build_query($body);

            // set body
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

            // send the request and save response to $response
            $response = curl_exec($ch);

            // stop if fails
            if (!$response) {
                $error = true;
                $mensaje = 'Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch);
                $response = null;
            }

            //echo 'HTTP Status Code: ' . curl_getinfo($ch, CURLINFO_HTTP_CODE) . PHP_EOL;
            //echo 'Response Body: ' . $response . PHP_EOL;

            if (curl_getinfo($ch, CURLINFO_HTTP_CODE) . PHP_EOL == 200) {
                $error = false;
            } else {
                $error = true;
                $response = null;
                $mensaje = json_encode($response, JSON_THROW_ON_ERROR);
            }

        } catch (Exception $exception) {
            $error = true;
            $mensaje = $exception->getMessage();
        } finally {
            // close curl resource to free up system resources
            curl_close($ch);
        }

        return $response;
    }

    public static function envioMailComprobante($tercero, $numero, $clave, $fechaAuto, $comprobante, $email, $pdf, $xml_autorizado, Empresa $empresa)
    {
        $html = Funciones::plantillaMail($tercero, $comprobante, $numero, $clave, $fechaAuto);

        file_put_contents($clave . '.pdf', $pdf);

        $pdf = file_get_contents($clave . '.pdf');

        $subject = $comprobante . ': ' . $numero;

        //$usuario = new User();
        $mailuser = $empresa->getMailfrom();
        $mailpass = $empresa->getPassmail();
        $mailhost = $empresa->getMailHost();
        $mailport = $empresa->getMailPort();
        $mailencrypt = $empresa->getMailStarttls();

        if (strcmp($mailhost, "smtp.gmail.com") == 0)
            $mailencrypt = "tls";

        $attachmentPdf = new \Swift_Attachment($pdf, $comprobante . '_' . $numero . '.pdf', 'application/pdf');

        if ($xml_autorizado != null)
            $attachmentXml = new \Swift_Attachment(utf8_decode($xml_autorizado), $comprobante . '_' . $numero . '.xml', 'application/xml');

        /*$transport = \Swift_SmtpTransport::newInstance()
            ->setHost($mailhost)
            ->setPort($mailport)
            ->setEncryption($mailencrypt)
            ->setUsername($mailuser)
            ->setPassword($mailpass)

        ;

        $mailer = \Swift_Mailer::newInstance($transport);

        $message = \Swift_Message::newInstance()
            ->setSubject($subject)
            ->setFrom($mailuser, $usuario->getName())
            ->setTo($email)
            ->setCc($usuario->getEmail())
            ->setBody($html, 'text/html',  'utf8')
            ->attach($attachmentPdf)
            ->attach($attachmentXml);

        //$message->setCharset('iso-8859-1');

        $headers = "\r\n" . "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=utf8" . "\r\n";

        $result = $mailer->send($message);
        */

        $transport = new \Swift_SmtpTransport();

        $transport->setAuthMode('login');
        $transport->setHost($mailhost);
        $transport->setPort($mailport);
        $transport->setEncryption($mailencrypt);
        $transport->setUsername($mailuser);
        $transport->setPassword($mailpass);

        $mailer = new \Swift_Mailer($transport);

        $message = new \Swift_Message();
        $message->setCharset('utf8');

        $message->setSubject($subject);
        $message->setFrom($mailuser, $empresa->getNombreComercial());
        $message->setTo($email);
        //$message->setCc($empresa->getEmail());
        $message->setBody($html, 'text/html');
        $message->attach($attachmentPdf);

        if ($xml_autorizado != null)
            $message->attach($attachmentXml);

        $result = $mailer->send($message, $failures);

        try {
            unlink($clave . ".pdf");
        } catch (\Exception $exception) {

        }

        return $result;

        /* $header = "Content-Type: text/html; charset=ISO-8859-1";

         $mail = new PHPMailer(true);


         $mail->isSMTP();
         $mail->Host = $mailhost;
         $mail->Port = $mailport;
         $mail->SMTPAuth = true;
         $mail->Username = $mailuser;
         $mail->Password = $mailpass;
         $mail->SMTPSecure = $mailencrypt;
         $mail->smtpClose();

         $mail->From = $mailuser;
         $mail->FromName = $usuario->getName();

         file_put_contents($clave . '.xml', utf8_decode($xml_autorizado));

         $mail->CharSet = 'UTF-8';
         //$mail->Encoding = "quoted­printable";


         $mail->addAttachment($clave . '.pdf');         // Add attachments
         $mail->addAttachment($clave . '.xml', 'auto.xml');    // Optional name


         $mail->addAddress($email);

         $mail->isHTML(true);
         $mail->Subject= $subject;
         $mail->Body =  $html;
         $isSend = $mail->send();

         return $isSend;
        */

    }

    function decodificar_utf8($cadena)
    {
        $buscar = ['À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ă', 'Ą', 'Ç', 'Ć', 'Č', 'Œ', 'Ď', 'Đ', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ă', 'ą', 'ç', 'ć', 'č', 'œ', 'ď', 'đ', 'È', 'É', 'Ê', 'Ë', 'Ę', 'Ě', 'Ğ', 'Ì', 'Í', 'Î', 'Ï', 'İ', 'Ĺ', 'Ľ', 'Ł', 'è', 'é', 'ê', 'ë', 'ę', 'ě', 'ğ', 'ì', 'í', 'î', 'ï', 'ı', 'ĺ', 'ľ', 'ł', 'Ñ', 'Ń', 'Ň', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ő', 'Ŕ', 'Ř', 'Ś', 'Ş', 'Š', 'ñ', 'ń', 'ň', 'ò', 'ó', 'ô', 'ö', 'ø', 'ő', 'ŕ', 'ř', 'ś', 'ş', 'š', 'Ţ', 'Ť', 'Ù', 'Ú', 'Û', 'Ų', 'Ü', 'Ů', 'Ű', 'Ý', 'ß', 'Ź', 'Ż', 'Ž', 'ţ', 'ť', 'ù', 'ú', 'û', 'ų', 'ü', 'ů', 'ű', 'ý', 'ÿ', 'ź', 'ż', 'ž', 'А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ', 'ъ', 'ы', 'ь', 'э', 'ю', 'я'];
        $remplazar = ['A', 'A', 'A', 'A', 'A', 'A', 'AE', 'A', 'A', 'C', 'C', 'C', 'CE', 'D', 'D', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'a', 'a', 'c', 'c', 'c', 'ce', 'd', 'd', 'E', 'E', 'E', 'E', 'E', 'E', 'G', 'I', 'I', 'I', 'I', 'I', 'L', 'L', 'L', 'e', 'e', 'e', 'e', 'e', 'e', 'g', 'i', 'i', 'i', 'i', 'i', 'l', 'l', 'l', 'N', 'N', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'R', 'R', 'S', 'S', 'S', 'n', 'n', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'r', 'r', 's', 's', 's', 'T', 'T', 'U', 'U', 'U', 'U', 'U', 'U', 'U', 'Y', 'Y', 'Z', 'Z', 'Z', 't', 't', 'u', 'u', 'u', 'u', 'u', 'u', 'u', 'y', 'y', 'z', 'z', 'z', 'A', 'B', 'B', 'r', 'A', 'E', 'E', 'X', '3', 'N', 'N', 'K', 'N', 'M', 'H', 'O', 'N', 'P', 'a', 'b', 'b', 'r', 'a', 'e', 'e', 'x', '3', 'n', 'n', 'k', 'n', 'm', 'h', 'o', 'p', 'C', 'T', 'Y', 'O', 'X', 'U', 'u', 'W', 'W', 'b', 'b', 'b', 'E', 'O', 'R', 'c', 't', 'y', 'o', 'x', 'u', 'u', 'w', 'w', 'b', 'b', 'b', 'e', 'o', 'r'];
        return str_replace($buscar, $remplazar, $cadena);

    }

    public static function plantillaMail($tercero, $comprobante, $numero, $clave, $fecha)
    {

        return "<br>Estimado(a), <b>" . $tercero . "</b>" .
            "<br><br>Hemos emitido el siguiente comprobante electronico." .
            "<br><br>Documento: <b>" . $comprobante . " Electronica</b>" .
            "<br>Numero: <b>" . $numero . "</b>" .
            "<br>Clave Acceso: <b>" . $clave . "</b>" .
            "<br>Fecha de Autorizacion: <b>" . $fecha . "</b>" .
            "<br><br>El documento xml y pdf de su <b>" . $comprobante . " Electronica</b>, se encuentra adjunto a este correo." .
            //"<br><br>Saludos cordiales," .

            //"<br><br>--------------------" .
            "<br><br>¡Gracias por apoyarnos a servirle mejor y a conservar el medio ambiente!" .
            "<br>Servicio proporcionado por: <b>www.sharafac.com</b>" .
            "<br><br>Las tildes han sido omitidas intencionalmente para evitar problemas de lectura<br><br><br><br>";
    }

    public static function getErrorValidacion($errors)
    {
        $messages = [];
        foreach ($errors as $violation) {
            //$messages[$violation->getPropertyPath()][] = $violation->getMessage();
            $messages[] = $violation->getMessage();
        }

        return $messages;
    }

    public static function cleanParametro($valor)
    {
        $condition = preg_replace('#[^A-Za-z0-9\- ]#', '', $valor);
        $condition = trim($condition);

        //$aux = str_replace(array("'", "\"", "'", '"'), array("'", "&quot;\"'", "&quot;", $condition));

        return str_replace(" ", "%", $condition);
    }

    public static function getValidaPuedeFacturar(Empresa $empresa, EntityManagerInterface $em, &$msg)
    {

        $puedefacturar = true;
        $msg = '';

        if ($empresa->getTipoAmbiente() === "2") {

            $fec_caduca = $empresa->getFechaCaduca();

            if ($fec_caduca) {

                $date1 = $fec_caduca;
                $date2 = new DateTime("now");

                if ($date1 < $date2) {
                    $msg = 'Tu plan ha caducado. Renueve tu plan o adquiera uno nuevo.';
                    $puedefacturar = false;
                }
            }
        }

        $empresa->setPuedefacturar($puedefacturar);
        $em->persist($empresa);
        $em->flush();

        return $puedefacturar;
    }

    public static function getValidaEmitidos(Empresa $empresa, EntityManagerInterface $em)
    {

        if ($empresa->getTipoAmbiente() === "2") {

            $repo = $em->getRepository('App\Entity\Model\Comprobantes');
            $total = 0;
            $facturas = $repo->countInvoiceEmitidos($empresa->getId());
            if ($facturas) {
                $total += $facturas;
            }

            $retenciones = $repo->countRetencionesEmitidos($empresa->getId());
            if ($retenciones) {
                $total += $retenciones;
            }

            $liquidaciones = $repo->countLiquidacionEmitidos($empresa->getId());
            if ($liquidaciones) {
                $total += $liquidaciones;
            }

            $ncreditos = $repo->countNcreditosEmitidos($empresa->getId());
            if ($ncreditos) {
                $total += $ncreditos;
            }

            $guias = $repo->countGuiasEmitidos($empresa->getId());
            if ($guias) {
                $total += $guias;
            }

            $plan = $empresa->getPlan();
            if ($plan !== null) {
                if ($plan->getId() !== null) {
                    if (!$plan->getIlimitado()) {
                        $contratados = $empresa->getCmpContratados();
                        $emitidos = $total;

                        $disponible = $contratados - $emitidos;

                        if ($disponible <= 0)
                            $empresa->setPuedefacturar(false);
                    }
                }
            }

            $empresa->setCmpEmitidos($total);
            $em->persist($empresa);
            $em->flush();

        }

        return $empresa;
    }

    public static function setEmisorApi(Empresa $empresa, $ruta_firma, $ruta_logo, $app_url)
    {

        $msg = null;
        //$app_url = $this->getParameter('api_url');
        $error = false;

        $data = array(
            'razon_social' => $empresa->getRazonSocial(),
            'nombre_comercial' => $empresa->getNombreComercial(),
            'dir_establecimiento' => $empresa->getDirEstablecimiento(),
            'cod_establecimiento' => '000',
            'contribuyente_especial' => $empresa->getContribuyenteEspecial(),
            'lleva_contabilidad' => $empresa->getLlevaContabilidad() === true ? 1 : 0,
            'cod_punto_emision' => '000',
            'tipo_ambiente' => $empresa->getTipoAmbiente() === 1 ? 'PRODUCCION' : 'PRUEBAS',
            'direccion_matriz' => $empresa->getDireccionMatriz(),
            'pass_firma' => $empresa->getPassFirma(),
            'mail_host' => $empresa->getMailHost(),
            'mail_port' => $empresa->getMailPort(),
            'mailfrom' => $empresa->getMailfrom(),
            'passmail' => $empresa->getPassmail(),
            'mail_starttls' => $empresa->getMailStarttls(),
            'emisor_id' => '-1',
            'agente_ret' => $empresa->getAgenteRet() === true ? 1 : 0,
        );

        if ($ruta_logo)
            $data['ruta_logo'] = $ruta_logo;
        if ($ruta_firma)
            $data['ruta_firma'] = $ruta_firma;

        $json = "";

        try {
            //$serializer = SerializerBuilder::create()->build();
            //$json = $serializer->serialize($data, 'json');
            $json = json_encode($data, JSON_UNESCAPED_UNICODE);
        } catch (\Exception $e) {

        }

        $resp = RestApiFunciones::enviarEmisorApi($error, $empresa->getRuc(), $json, $app_url, $ruta_firma, $ruta_logo);

        if ($error) {
            $msg = "Error envio servidor api, " . json_encode($resp);
            //$this->addFlash('danger', $msg);
        } else {
            try {
                unlink($data['ruta_logo']);
            } catch (\Exception $ex) {
            }
            try {
                unlink($data['ruta_firma']);
            } catch (\Exception $ex) {
            }
        }

        return $msg;
    }

    public static function createNewUser(UserPasswordHasherInterface $passwordEncoder, EntityManagerInterface $em, TransporteSocio $socio, string $base_api)
    {
        try {

            $error = false;
            $dbParams = $em->getConnection()->getParams();

            $conn = Funciones::getConnection($error, $dbParams, $base_api);

            if ($error) {
                return $conn;
            }
            $conn->beginTransaction();
            $user = new User();
            $user->setUsername($socio->getRucsocio());
            $user->setEmail($socio->getEmail());
            $user->setRazonSocial($socio->getNombresocio());
            $user->setRuc($socio->getRucsocio());

            $user->setPassword(
                $passwordEncoder->hashPassword(
                    $user,
                    $socio->getPassword()
                )
            );

            $data["email"] = $user->getEmail();
            $data["username"] = $user->getUsername();
            $data["razon_social"] = $user->getRazonSocial();
            $data["roles"] = '[]';
            $dt = new \DateTime('now');
            $data["create_date"] = $dt->format('Y-m-d H:i:s');
            $data["ruc"] = $user->getRuc();
            $data["password"] = $user->getPassword();
            $data["data_base"] = $dbParams["dbname"];
            $data["plan_id"] = '0';

            $tableName = $em->getClassMetadata(User::class)->getTableName();

            $fields = Funciones::getParamsInsert($data, true);
            $values = Funciones::getParamsInsert($data);
            $sql = "INSERT INTO $tableName ($fields) VALUES ($values)";

            $statement = $conn->prepare($sql);
            $statement = Funciones::bindAllValues($statement, $data);

            $statement->execute();
            $conn->commit();
            $conn = null;

        } catch (PDOException $exception) {
            $conn->rollback();
            return ("Error insert new socio " . $exception->getMessage());
        }

        return null;
    }

    public static function getConnection(&$error, $dbParams, string $base_api)
    {
        $error = false;
        try {
            $conn = new PDO("mysql:host=" . $dbParams["host"] . ";dbname=" . $base_api . ";charset=" . $dbParams["charset"], $dbParams["user"], $dbParams["password"]);
            // set the PDO error mode to exception
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $conn;
        } catch (PDOException $exception) {
            $error = true;
            return ("Connection PDO failed, create user new socio transportista: " . $exception->getMessage());
        }
    }

    public static function getParamsInsert($input, $values = false)
    {
        $filterParams = [];
        foreach ($input as $param => $value) {
            if ($values)
                $filterParams[] = "$param";
            else
                $filterParams[] = ":$param";
        }
        return implode(", ", $filterParams);
    }

    //Asociar todos los parametros a un sql
    public static function bindAllValues($statement, $params)
    {
        try {
            foreach ($params as $param => $value) {
                $statement->bindValue(':' . $param, $value);
            }

        } catch (\Exception $ex) {
            var_dump($ex);
        }

        return $statement;
    }

}
