<?php

namespace App\Controller;

use App\Entity\Model\Empresa;
use App\Entity\Model\User;
use App\Service\EmFactory;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Translation\Translator;

/**
 * @Route("/empresa")
 */
class EmpresaController extends AbstractController
{
    /**
     * @Route("", name="empresa_index")
     *
     */
    public function indexAction(Request $request, EntityManagerInterface $entityManager): \Symfony\Component\HttpFoundation\Response
    {
        $em = $entityManager;
        $user = $this->getUser();
        $empresa = $user->getEmpresa();
        $repo = $em->getRepository('SiwappCustomerBundle:Customer');
        $repo->setPaginator($this->get('knp_paginator'));
        // @todo Unhardcode this.
        $limit = 50;

        $form = $this->createForm(\App\Form\SearchCustomerType::class, null, [
            'action' => $this->generateUrl('customer_index'),
            'method' => 'GET',
        ]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $pagination = $repo->paginatedSearch($form->getData(), $limit, $request->query->getInt('page', 1));
        } else {
            $pagination = $repo->paginatedSearch([], $limit, $request->query->getInt('page', 1));
        }

        $customers = [];
        foreach ($pagination->getItems() as $item) {
            $customers[] = $item[0];
        }

        $listForm = $this->createForm('App\Form\ListCustomerType', $customers, [
            'action' => $this->generateUrl('customer_index'),
        ]);
        $listForm->handleRequest($request);
        if ($listForm->isSubmitted() && $listForm->isValid()) {
            $data = $listForm->getData();
            if ($request->request->has('delete')) {
                if (empty($data['customers'])) {
                    $this->addTranslatedMessage('flash.nothing_selected', 'warning');
                }
                else {
                    foreach ($data['customers'] as $customer) {
                        $em->remove($customer);
                    }

                    $em->flush();
                    $this->addTranslatedMessage('flash.bulk_deleted');

                    // Rebuild the query, since some objects are now missing.
                    return $this->redirectToRoute('customer_index');
                }
            }
        }

        return $this->render('Empresa\index.html.twig',
         [
             'customers' => $pagination,
             //'currency' => $em->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR'),
             'currency' => $empresa == null ? 'USD':$empresa->getCurrency(),
             'search_form' => $form->createView(),
             'list_form' => $listForm->createView(),
         ]);
    }

    protected function addTranslatedMessage($message, $status = 'success')
    {
        $translator = new Translator('en_EN');

        $this->addFlash($status, $translator->trans($message, [], 'SiwappCustomerBundle'));
    }


}
