<?php

namespace App\Electronico\GuiaRemision;

use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;


class InfoGuiaRemision
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("dirEstablecimiento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirEstablecimiento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("dirPartida")
     * @Serializer\XmlElement(cdata=false)
     */
    private $dirPartida;

    /**
     * @Serializer\Type("string")
     * @SerializedName("razonSocialTransportista")
     * @Serializer\XmlElement(cdata=false)
     */
    private $razonSocialTransportista;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoIdentificacionTransportista")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoIdentificacionTransportista;

    /**
     * @Serializer\Type("string")
     * @SerializedName("rucTransportista")
     * @Serializer\XmlElement(cdata=false)
     */
    private $rucTransportista;

    /**
     * @Serializer\Type("string")
     * @SerializedName("obligadoContabilidad")
     * @Serializer\XmlElement(cdata=false)
     */
    private $obligadoContabilidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("contribuyenteEspecial")
     * @Serializer\XmlElement(cdata=false)
     */
    private $contribuyenteEspecial;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaIniTransporte")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaIniTransporte;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaFinTransporte")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaFinTransporte;

    /**
     * @Serializer\Type("string")
     * @SerializedName("placa")
     * @Serializer\XmlElement(cdata=false)
     */
    private $placa;

    public function __construct()
    {
    }

    /**
     * @return mixed
     */
    public function getDirEstablecimiento()
    {
        return $this->dirEstablecimiento;
    }

    /**
     * @param mixed $dirEstablecimiento
     */
    public function setDirEstablecimiento($dirEstablecimiento): void
    {
        $this->dirEstablecimiento = $dirEstablecimiento;
    }

    /**
     * @return mixed
     */
    public function getDirPartida()
    {
        return $this->dirPartida;
    }

    /**
     * @param mixed $dirPartida
     */
    public function setDirPartida($dirPartida): void
    {
        $this->dirPartida = $dirPartida;
    }

    /**
     * @return mixed
     */
    public function getRazonSocialTransportista()
    {
        return $this->razonSocialTransportista;
    }

    /**
     * @param mixed $razonSocialTransportista
     */
    public function setRazonSocialTransportista($razonSocialTransportista): void
    {
        $this->razonSocialTransportista = $razonSocialTransportista;
    }

    /**
     * @return mixed
     */
    public function getTipoIdentificacionTransportista()
    {
        return $this->tipoIdentificacionTransportista;
    }

    /**
     * @param mixed $tipoIdentificacionTransportista
     */
    public function setTipoIdentificacionTransportista($tipoIdentificacionTransportista): void
    {
        $this->tipoIdentificacionTransportista = $tipoIdentificacionTransportista;
    }

    /**
     * @return mixed
     */
    public function getRucTransportista()
    {
        return $this->rucTransportista;
    }

    /**
     * @param mixed $rucTransportista
     */
    public function setRucTransportista($rucTransportista): void
    {
        $this->rucTransportista = $rucTransportista;
    }

    /**
     * @return mixed
     */
    public function getObligadoContabilidad()
    {
        return $this->obligadoContabilidad;
    }

    /**
     * @param mixed $obligadoContabilidad
     */
    public function setObligadoContabilidad(bool $obligadoContabilidad)
    {
        $this->obligadoContabilidad = $obligadoContabilidad ? 'SI' : 'NO';
    }

    /**
     * @return mixed
     */
    public function getContribuyenteEspecial()
    {
        return $this->contribuyenteEspecial;
    }

    /**
     * @param mixed $contribuyenteEspecial
     */
    public function setContribuyenteEspecial($contribuyenteEspecial): void
    {
        $this->contribuyenteEspecial = $contribuyenteEspecial;
    }

    /**
     * @return mixed
     */
    public function getFechaIniTransporte()
    {
        return $this->fechaIniTransporte;
    }

    /**
     * @param mixed $fechaIniTransporte
     */
    public function setFechaIniTransporte($fechaIniTransporte): void
    {
        $this->fechaIniTransporte = $fechaIniTransporte;
    }

    /**
     * @return mixed
     */
    public function getFechaFinTransporte()
    {
        return $this->fechaFinTransporte;
    }

    /**
     * @param mixed $fechaFinTransporte
     */
    public function setFechaFinTransporte($fechaFinTransporte): void
    {
        $this->fechaFinTransporte = $fechaFinTransporte;
    }

    /**
     * @return mixed
     */
    public function getPlaca()
    {
        return $this->placa;
    }

    /**
     * @param mixed $placa
     */
    public function setPlaca($placa): void
    {
        $this->placa = $placa;
    }

}

