<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 11/09/2017
 * Time: 11:10
 */

namespace App\Electronico\LiquidacionCompra;


use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class ReembolsoDetalle
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoIdentificacionProveedorReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoIdentificacionProveedorReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("identificacionProveedorReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $identificacionProveedorReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codPaisPagoProveedorReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codPaisPagoProveedorReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("tipoProveedorReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $tipoProveedorReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("estabDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $estabDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("ptoEmiDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $ptoEmiDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("secuencialDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $secuencialDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmisionDocReembolso")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmisionDocReembolso;

    /**
     * @Serializer\Type("string")
     * @SerializedName("numeroautorizacionDocReemb")
     * @Serializer\XmlElement(cdata=false)
     */
    private $numeroautorizacionDocReemb;


    /**
     * @SerializedName("detalleImpuestos")
     * @XmlList(inline = false, entry = "detalleImpuesto")
     */
    private $detalleImpuestos;


    public function __construct()
    {

    }

    /**
     * @return mixed
     */
    public function getTipoIdentificacionProveedorReembolso()
    {
        return $this->tipoIdentificacionProveedorReembolso;
    }

    /**
     * @param mixed $tipoIdentificacionProveedorReembolso
     */
    public function setTipoIdentificacionProveedorReembolso($tipoIdentificacionProveedorReembolso): void
    {
        $this->tipoIdentificacionProveedorReembolso = $tipoIdentificacionProveedorReembolso;
    }

    /**
     * @return mixed
     */
    public function getIdentificacionProveedorReembolso()
    {
        return $this->identificacionProveedorReembolso;
    }

    /**
     * @param mixed $identificacionProveedorReembolso
     */
    public function setIdentificacionProveedorReembolso($identificacionProveedorReembolso): void
    {
        $this->identificacionProveedorReembolso = $identificacionProveedorReembolso;
    }

    /**
     * @return mixed
     */
    public function getCodPaisPagoProveedorReembolso()
    {
        return $this->codPaisPagoProveedorReembolso;
    }

    /**
     * @param mixed $codPaisPagoProveedorReembolso
     */
    public function setCodPaisPagoProveedorReembolso($codPaisPagoProveedorReembolso): void
    {
        $this->codPaisPagoProveedorReembolso = $codPaisPagoProveedorReembolso;
    }

    /**
     * @return mixed
     */
    public function getTipoProveedorReembolso()
    {
        return $this->tipoProveedorReembolso;
    }

    /**
     * @param mixed $tipoProveedorReembolso
     */
    public function setTipoProveedorReembolso($tipoProveedorReembolso): void
    {
        $this->tipoProveedorReembolso = $tipoProveedorReembolso;
    }

    /**
     * @return mixed
     */
    public function getCodDocReembolso()
    {
        return $this->codDocReembolso;
    }

    /**
     * @param mixed $codDocReembolso
     */
    public function setCodDocReembolso($codDocReembolso): void
    {
        $this->codDocReembolso = $codDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getEstabDocReembolso()
    {
        return $this->estabDocReembolso;
    }

    /**
     * @param mixed $estabDocReembolso
     */
    public function setEstabDocReembolso($estabDocReembolso): void
    {
        $this->estabDocReembolso = $estabDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getPtoEmiDocReembolso()
    {
        return $this->ptoEmiDocReembolso;
    }

    /**
     * @param mixed $ptoEmiDocReembolso
     */
    public function setPtoEmiDocReembolso($ptoEmiDocReembolso): void
    {
        $this->ptoEmiDocReembolso = $ptoEmiDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getSecuencialDocReembolso()
    {
        return $this->secuencialDocReembolso;
    }

    /**
     * @param mixed $secuencialDocReembolso
     */
    public function setSecuencialDocReembolso($secuencialDocReembolso): void
    {
        $this->secuencialDocReembolso = $secuencialDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getFechaEmisionDocReembolso()
    {
        return $this->fechaEmisionDocReembolso;
    }

    /**
     * @param mixed $fechaEmisionDocReembolso
     */
    public function setFechaEmisionDocReembolso($fechaEmisionDocReembolso): void
    {
        $this->fechaEmisionDocReembolso = $fechaEmisionDocReembolso;
    }

    /**
     * @return mixed
     */
    public function getNumeroautorizacionDocReemb()
    {
        return $this->numeroautorizacionDocReemb;
    }

    /**
     * @param mixed $numeroautorizacionDocReemb
     */
    public function setNumeroautorizacionDocReemb($numeroautorizacionDocReemb): void
    {
        $this->numeroautorizacionDocReemb = $numeroautorizacionDocReemb;
    }


    /**
     * @return mixed
     */
    public function getDetalleImpuestos()
    {
        return $this->detalleImpuestos;
    }

    /**
     * @param mixed $impuestos
     */
    public function setDetalleImpuestos(array $impuestos)
    {
        $this->detalleImpuestos = $impuestos;
    }

}