<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 11/09/2017
 * Time: 11:10
 */

namespace App\Electronico\NotaCreditos;


use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class Detalle
{
    /**
     * @Serializer\Type("string")
     * @SerializedName("codigoInterno")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codigoInterno;


    /**
     * @Serializer\Type("string")
     * @SerializedName("descripcion")
     * @Serializer\XmlElement(cdata=false)
     */
    private $descripcion;

    /**
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     */
    private $cantidad;

    /**
     * @Serializer\Type("string")
     * @SerializedName("precioUnitario")
     * @Serializer\XmlElement(cdata=false)
     */
    private $precioUnitario;

    /**
     * @Serializer\Type("string")
     * @SerializedName("descuento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $descuento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("precioTotalSinImpuesto")
     * @Serializer\XmlElement(cdata=false)
     */
    private $precioTotalSinImpuesto;


    /**
     * @SerializedName("impuestos")
     * @XmlList(inline = false, entry = "impuesto")
     */
    private $impuestos;


    public function __construct()
    {

    }

    /**
     * @return mixed
     */
    public function getCodigoInterno()
    {
        return $this->codigoInterno;
    }

    /**
     * @param mixed $codigoInterno
     */
    public function setCodigoInterno($codigoInterno)
    {
        $this->codigoInterno = $codigoInterno;
    }

    /**
     * @return mixed
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }

    /**
     * @param mixed $descripcion
     */
    public function setDescripcion($descripcion)
    {
        $this->descripcion = $descripcion;
    }

    /**
     * @return mixed
     */
    public function getCantidad()
    {
        return $this->cantidad;
    }

    /**
     * @param mixed $cantidad
     */
    public function setCantidad($cantidad)
    {
        $this->cantidad = number_format($cantidad, 2, '.', '');;
    }

    /**
     * @return mixed
     */
    public function getPrecioUnitario()
    {
        return $this->precioUnitario;
    }

    /**
     * @param mixed $precioUnitario
     */
    public function setPrecioUnitario($precioUnitario)
    {
        $this->precioUnitario = number_format($precioUnitario, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getDescuento()
    {
        return $this->descuento;
    }

    /**
     * @param mixed $descuento
     */
    public function setDescuento($descuento)
    {
        $this->descuento = number_format($descuento, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getPrecioTotalSinImpuesto()
    {
        return $this->precioTotalSinImpuesto;
    }

    /**
     * @param mixed $precioTotalSinImpuesto
     */
    public function setPrecioTotalSinImpuesto($precioTotalSinImpuesto)
    {
        $this->precioTotalSinImpuesto = number_format($precioTotalSinImpuesto, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getImpuestos()
    {
        return $this->impuestos;
    }

    /**
     * @param mixed $impuestos
     */
    public function setImpuestos(array $impuestos)
    {
        $this->impuestos = $impuestos;
    }



}