<?php
/**
 * Created by PhpStorm.
 * User: svycar
 * Date: 07/09/2017
 * Time: 17:57
 */

namespace App\Electronico\Retencion;

use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\XmlList;
use JMS\Serializer\Annotation as Serializer;

class Impuesto
{
    /**
     * @Serializer\Type("integer")
     * @SerializedName("codigo")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigo;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codigoRetencion")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $codigoRetencion;

    /**
     * @Serializer\Type("string")
     * @SerializedName("baseImponible")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $baseImponible;


    /**
     * @Serializer\Type("string")
     * @SerializedName("porcentajeRetener")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $porcentajeRetener;


    /**
     * @Serializer\Type("string")
     * @SerializedName("valorRetenido")
     * @Serializer\XmlElement(cdata=false)
     */
    private  $valorRetenido;

    /**
     * @Serializer\Type("string")
     * @SerializedName("codDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $codDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("numDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $numDocSustento;

    /**
     * @Serializer\Type("string")
     * @SerializedName("fechaEmisionDocSustento")
     * @Serializer\XmlElement(cdata=false)
     */
    private $fechaEmisionDocSustento;



    /**
     * @return mixed
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param mixed $codigo
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return mixed
     */
    public function getCodigoRetencion()
    {
        return $this->codigoRetencion;
    }

    /**
     * @param mixed $codigoRetencion
     */
    public function setCodigoRetencion($codigoRetencion)
    {
        $this->codigoRetencion = $codigoRetencion;
    }


    /**
     * @return mixed
     */
    public function getBaseImponible()
    {
        return $this->baseImponible;
    }

    /**
     * @param mixed $baseImponible
     */
    public function setBaseImponible($baseImponible)
    {
        $this->baseImponible = number_format($baseImponible, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getPorcentajeRetener()
    {
        return $this->porcentajeRetener;
    }

    /**
     * @param mixed $porcentajeRetener
     */
    public function setPorcentajeRetener($porcentajeRetener)
    {
        $this->porcentajeRetener = $porcentajeRetener;
    }


    /**
     * @return mixed
     */
    public function getValorRetenido()
    {
        return $this->valorRetenido;
    }

    /**
     * @param mixed $valorRetenido
     */
    public function setValorRetenido($valorRetenido)
    {
        $this->valorRetenido = number_format($valorRetenido, 2, '.', '');
    }

    /**
     * @return mixed
     */
    public function getCodDocSustento()
    {
        return $this->codDocSustento;
    }

    /**
     * @param mixed $codDocSustento
     */
    public function setCodDocSustento($codDocSustento)
    {
        $this->codDocSustento = $codDocSustento;
    }

    /**
     * @return mixed
     */
    public function getNumDocSustento()
    {
        return $this->numDocSustento;
    }

    /**
     * @param mixed $numDocSustento
     */
    public function setNumDocSustento($numDocSustento)
    {
        $this->numDocSustento = $numDocSustento;
    }

    /**
     * @return mixed
     */
    public function getFechaEmisionDocSustento()
    {
        return $this->fechaEmisionDocSustento;
    }

    /**
     * @param mixed $fechaEmisionDocSustento
     */
    public function setFechaEmisionDocSustento($fechaEmisionDocSustento)
    {
        $this->fechaEmisionDocSustento = $fechaEmisionDocSustento;
    }

}