<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * App\Entity\Model\FormaPago
 *
 * @ORM\Table()
 * @ORM\Entity(repositoryClass="App\Repository\PropertyRepository")
 */
class FormaPago
{
    /**
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id;

    /**
     * @var date $create_date
     *
     * @ORM\Column(name="create_date", type="date", nullable=true)
     */

    private $create_date;

    /**
     * @ORM\Column(name="name", type="string", length=191)
     */
    private  $name = null;

    /**
     * @ORM\Column(name="codigo", type="string", length=2)
     */
    private  $codigo = null;

    /**
     * @var boolean $enabled
     *
     * @ORM\Column(name="enabled", type="boolean")
     */
    private $enabled = 1;

    /**
     * Empresa constructor.
     */
    public function __construct()
    {
        $this->create_date = new \DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @param string $codigo
     */
    public function setCodigo(string $codigo)
    {
        $this->codigo = $codigo;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }



}
