<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * App\Entity\Model\Item
 *
 * @ORM\Entity(repositoryClass="App\Repository\ItemRepository")
 * @ORM\Table(indexes={
 *    @ORM\Index(name="guiaremision_item_desc_idx", columns={"description"})
 * })
 */
class ItemGuia
{

    /**
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private  $id;

    /**
     * @var decimal $quantity
     *
     * @ORM\Column(type="decimal", precision=20, scale=6)
     * @Assert\NotBlank()
     */
    private $quantity = 1;

    /**
     * @ORM\Column()
     */
    private  $description = null;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\Product", inversedBy="items")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $product;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\Model\Destinatario", mappedBy="items")
     */
    private $destinatario;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Model\GuiaRemision")
     * @ORM\JoinColumn(name="guiaremision_id", referencedColumnName="id", onDelete="SET NULL")
     */
    private $guiaremision;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get quantity
     *
     * @return decimal
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Set Quantity
     *
     * @param decimal $quantity
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set description
     *
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = strtoupper($description);
    }

    /**
     * Get product
     *
     * @return \App\Entity\Model\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Set product
     *
     * @param \App\Entity\Model\Product $product
     */
    public function setProduct(Product $product)
    {
        $this->product = $product;
    }

    /** **************** CUSTOM METHODS ************* */

    public function __toString()
    {
        return (string) $this->description.': '.$this->quantity;
    }

    public function __construct()
    {
    }

    public function jsonSerialize()
    {
        return [
            'id' => $this->getId(),
            'description' => $this->getDescription(),
        ];
    }

    /**
     * @return mixed
     */
    public function getGuiaremision()
    {
        return $this->guiaremision;
    }

    /**
     * @param mixed $guiaremision
     */
    public function setGuiaremision($guiaremision): void
    {
        $this->guiaremision = $guiaremision;
    }


}
