<?php

namespace App\Entity\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * App\Entity\Model\Planes
 *
 * @ORM\Entity(repositoryClass="App\Repository\PlanesRepository")
 * @ORM\Table()
 */
class Planes
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     * @Assert\NotBlank()
     */
    private $name;

    /**
     * @var integer $num_fac_mes
     *
     * @ORM\Column(type="integer")
     */
    private $num_fac_mes;

    /**
     * @var decimal $discount
     *
     * @ORM\Column(type="decimal", precision=15, scale=2)
     */
    private $val_max_fac;

    /**
     * @var decimal $discount
     *
     * @ORM\Column(type="decimal", precision=15, scale=2)
     */
    private $precio_mes;

    /**
     * @var boolean $enabled
     *
     * @ORM\Column(name="enabled", type="boolean")
     */
    private $enabled;

    /**
     * @var boolean $enabled
     *
     * @ORM\Column(name="ilimitado", type="boolean")
     */
    private $ilimitado;

    /**
     * @var integer $orden
     *
     * @ORM\Column(type="integer", nullable=true)
     */
    private $orden;

    /**
     * @var text $xml
     *
     * @ORM\Column(type="text", nullable=true)
     */
    private $detalle;

    /**
     * @var integer $dias_pago
     *
     * @ORM\Column(type="integer")
     */
    private $dias_pago;

    public function __construct()
    {
        $this->enabled = true;
        $this->ilimitado = false;
        $this->dias_pago = 5;
    }

    public function __toString(): string
    {
        return $this->name;
    }


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = strtoupper($name);
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getNumFacMes()
    {
        return $this->num_fac_mes;
    }

    /**
     * @param int $num_fac_mes
     */
    public function setNumFacMes($num_fac_mes)
    {
        $this->num_fac_mes = $num_fac_mes;
    }

    /**
     * @return decimal
     */
    public function getValMaxFac()
    {
        return $this->val_max_fac;
    }

    /**
     * @param decimal $val_max_fac
     */
    public function setValMaxFac($val_max_fac)
    {
        $this->val_max_fac = $val_max_fac;
    }

    /**
     * @return decimal
     */
    public function getPrecioMes()
    {
        return $this->precio_mes;
    }

    /**
     * @param decimal $precio_mes
     */
    public function setPrecioMes($precio_mes)
    {
        $this->precio_mes = $precio_mes;
    }

    /**
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return bool
     */
    public function getIlimitado()
    {
        return $this->ilimitado;
    }

    /**
     * @param bool $ilimitado
     */
    public function setIlimitado($ilimitado)
    {
        $this->ilimitado = $ilimitado;
    }

    /**
     * @return text
     */
    public function getDetalle()
    {
        return $this->detalle;
    }

    /**
     * @param text $detalle
     */
    public function setDetalle($detalle)
    {
        $this->detalle = $detalle;
    }

    /**
     * @return int
     */
    public function getOrden()
    {
        return $this->orden;
    }

    /**
     * @param int $orden
     */
    public function setOrden($orden)
    {
        $this->orden = $orden;
    }

    /**
     * @return int
     */
    public function getDiasPago()
    {
        return $this->dias_pago;
    }

    /**
     * @param int $dias_pago
     */
    public function setDiasPago($dias_pago)
    {
        $this->dias_pago = $dias_pago;
    }

}
