<?php

namespace App\Extension;

use App\Entity\Model\Empresa;
use App\Entity\Model\Planes;
use App\Service\EmFactory;
use App\Util\Funciones;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use DateTime;

/**
 * This is a Twig extension with methods common to all the application.
 */
class CoreTwigExtension extends AbstractExtension
{

    protected $em;

    public function __construct(EmFactory $emFactory)
    {
        $this->em = $emFactory;
    }

    public function getName(): string
    {
        return 'siwapp_core_twig_extension';
    }

    public function getFilters()
    {
        return array(
            new TwigFilter('menu_active_tab', [$this, 'menu_active_tab']),
            new TwigFilter('menu_tree_open', [$this, 'menu_tree_open']),
            new TwigFilter('menu_tree_display', [$this, 'menu_tree_display']),
        );
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('siwapp_version', [$this, 'version']),
            new TwigFunction('bundle_exists', [$this, 'bundleExists']),
            new TwigFunction('user_empresa_name', [$this, 'empresa']),
            new TwigFunction('user_empresa_ambiente', [$this, 'ambiente']),
            new TwigFunction('user_empresa_emitidos', [$this, 'emitidos']),

        ];
    }

    /**
     * @param string $routename Name of the route
     * @param string $prefix Prefix to test
     * @return string "active" if $routename is prefixed by $prefix
     * Ex: dashboard_index, dashboard_ => "active"
     * Ex: dashboard_index, invoice_   => ""
     */
    public function menu_active_tab($routename, $prefix)
    {
        return ($this->buscarPrefix($routename, $prefix) ? "active" : "");
    }

    public function menu_tree_open($routename, $prefix)
    {
        return ($this->buscarPrefix($routename, $prefix) ? "active menu-open" : "");
    }

    public function menu_tree_display($routename, $prefix)
    {
        return ($this->buscarPrefix($routename, $prefix) ? "block;" : "none;");
    }

    protected function buscarPrefix($routename, $prefix)
    {
        $aux = explode(",", $prefix);
        $encontro = false;
        foreach ($aux as $item) {
            if (strpos($routename, $item) === 0) {
                $encontro = true;
                break;
            }
        }

        return $encontro;
    }

    public function empresa()
    {
        $user = $this->em->getUser();
        $empresaRepo = $this->em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        return ($empresa->getRazonsocial());
    }

    public function emitidos()
    {

        $user = $this->em->getUser();
        $empresaRepo = $this->em->getRepository('App\Entity\Model\Empresa');
        $empresa = $empresaRepo->findOneByUser($user->getRuc());

        $msg = '';

        if ($empresa->getTipoAmbiente() === "2") {

            $fec_caduca = $empresa->getFechaCaduca();

            if ($fec_caduca == null)
                return '';

            $date1 = $fec_caduca;
            $date2 = new DateTime("now");

            if ($date1 < $date2) {
                $msg = '<h3 class="box-title" style="color:red">Tu plan ha caducado.' . ' Renueve tu plan o adquiera uno nuevo.</h3>';
                return $msg;
            }

            $diff = $date1->diff($date2);
            //$dias= $this->get_format($diff);

            $color = 'black';
            $msgcaduca = 'Tu plan caduca el: ' . $empresa->getFechaCaduca()->format('d/M/Y');
            $dias = $diff->days;

            if ($dias === 0) {
                $horas = $diff->h;
                $minutos = $diff->i;
                $msgcaduca = 'Tu plan caduca en ' . $horas . ' horas ' . $minutos . ' minutos ';
                $color = 'red';
            } else if ($dias <= 10) {
                if ($dias >= 5 && $dias <= 10) {
                    $color = 'darkorange';
                } elseif ($dias < 5) {
                    $color = 'red';
                }

                //$firma['caduca'] = $fec_firma->format('d M Y');
                $msgcaduca = 'Tu plan caduca en ' . $dias . ' dias';

            }

            //$empresa = new Empresa();
            $plan = $empresa->getPlan();
            $msgplan = 'Plan ';
            if ($plan !== null) {
                if ($plan->getId() !== null) {
                    //$plan = new Planes();
                    if ($plan->getIlimitado())
                        $msgplan .= 'Ilimitado. ';
                    else {

                        $empresa = Funciones::getValidaEmitidos($empresa, $this->em->getEm());

                        $contratados = $empresa->getCmpContratados();
                        $emitidos = $empresa->getCmpEmitidos();

                        $disponible = $contratados - $emitidos;
                        $msgplan = ' Te quedan '.$disponible.' comprobante(s) disponibles en tu plan '.strtolower($plan->getName() ). '. ';

                    }
                }
            }

            $advertencia = $msgplan . ' <span style="color:  ' . $color . '">' . $msgcaduca . '</span>';

            $msg = '<h3 class="box-title" >' . $advertencia . '</h3>';

        }

        return ($msg);
    }

    public function ambiente()
    {
        $user = $this->em->getUser();
        $empresaRepo = $this->em->getRepository(\App\Entity\Model\Empresa::class);
        $empresa = $empresaRepo->findOneByUser($user->getRuc());
        //$empresa = new Empresa();

        return ($empresa->getTipoAmbiente() === '1' ? 'PRUEBAS' : 'PRODUCCION');
    }

    public function version(): string
    {
        return \Siwapp\CoreBundle\SiwappCoreBundle::version;
    }
}
