<?php

namespace App\Form;

use App\Entity\Model\ItemGuia;
use App\Service\EmFactory;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class DestinatarioType extends AbstractType
{
    private $manager;

    private $security;

    private $empresa;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        //$currency = $this->manager->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR');
        $user = $this->security->getUser();
        $empresaRepo = $this->manager->getRepository(\App\Entity\Model\Empresa::class);
        $this->empresa = $empresaRepo->findOneByUser($user->getRuc());

        $builder
            //->add('product', TextType::class, ['required' => false])
            ->add('customer_name', TextType::class, [
                'required' => true,
                'attr' => ['autocomplete' => 'off', 'maxlength'=>200, 'readonly' => 'readonly'],
                'label' => 'form.customer_name',
                'translation_domain' => 'invoice',
            ])
            ->add('customer_identification', TextType::class, [
                'required' => true,
                'label' => 'form.customer_identification',
                'attr' => ['autocomplete' => 'off', 'maxlength'=>20 ],
                'translation_domain' => 'invoice',
            ])
            ->add('customer_email', EmailType::class, [
                'required' => true,
                'attr' => ['readonly' => 'readonly', 'autocomplete' => 'off', 'maxlength'=>200 ],
                'label' => 'form.customer_email',
                'translation_domain' => 'invoice',
            ])
            ->add('dir_destino', TextType::class, [
                'required' => true,
                'attr' => ['rows' => 1, 'autocomplete' => 'off', 'maxlength'=>200],
                'label' => 'Dirección Destino',
            ])
            ->add('motivoTraslado', TextType::class, [
                'required' => true,
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off', 'maxlength'=>200 ],
                'label' => 'Motivo Traslado',
            ])
            ->add('ruta', null, [
                'attr' => ['class' => 'sv_uppercase', 'autocomplete' => 'off', 'maxlength'=>200 ],
                'label' => 'Ruta',
            ])
            ->add('codEstabDestino', null, [
                'attr' => ['autocomplete' => 'off', 'maxlength'=>3 ],
                'label' => 'Cod Establecimiento Destino',
            ])
            ->add('docAduanero', null, [
                'attr' => ['autocomplete' => 'off', 'maxlength'=>20 ],
                'label' => 'Documento Aduanero',
            ])
            ->add('invoiceFecha', DateType::class, [
                'widget' => 'single_text',
                'required' => false,
                'label' => 'Fecha Factura',
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('invoiceSerie', null, [
                'attr' => ['autocomplete' => 'off', 'maxlength'=>6 ],
                'label' => 'Serie Factura',
            ])
            ->add('invoiceAutorizacion', null, [
                'attr' => ['autocomplete' => 'off', 'maxlength'=>49 ],
                'label' => 'Autorización Factura',
            ])
            ->add('invoiceNumero', null, [
                'attr' => ['autocomplete' => 'off', 'maxlength'=>9 ],
                'label' => 'Número Factura',
            ])
        ;

        $newItem = new ItemGuia();

        $builder->add('items', CollectionType::class, ['entry_type' => ItemGuiaType::class, 'allow_add' => true, 'allow_delete' => true, 'prototype' => true, 'by_reference' => false, 'label' => false, 'prototype_data' => $newItem]);


        /*$builder->get('product')
            ->addModelTransformer(new CallbackTransformer(
                function ($product) {
                    return $product ? $product->getReference() : '';
                },
                function ($reference) {
                    $product = $this->manager
                        ->getRepository('SiwappProductBundle:Product')
                        ->findOneBy(['reference' => $reference]);

                    return $product;
                }
            ));
        */
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\Destinatario::class,
            'attr' => ['id' => 'formdestinatariosv']
        ]);
    }
}
