<?php

namespace App\Form;

use App\Service\EmFactory;
use Doctrine\ORM\EntityRepository;
use App\Entity\Model\TipoRetencion;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ItemRetencionType extends AbstractType
{
    private $manager;

    private $security;

    public function __construct(EmFactory $manager, Security $security)
    {
        $this->manager = $manager;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        //$currency = $this->manager->getRepository('SiwappConfigBundle:Property')->get('currency', 'EUR');
        $builder
            ->add('tipoRetencion', TextType::class, [
                'label'=>'Referencia','required' => false,
                'attr' => ['autocomplete' => 'off'],
            ])
            ->add('base', NumberType::class,[
                'label'=>'Base',
                'required' => true,
                'scale' => 2,
                'grouping' => true,
                'attr' => ['class' => 'svtext-right', 'onkeypress'=>"return filterFloat(event,this)", 'autocomplete' => 'off']])
            //sv_shara modificado
            /*->add('discount_percent', NumberType::class, array (
                'required' => true,
                'scale' => 2,
                /*'attr' => array(
                    'class' => 'sv_currency'
                ),

            ))
            */

            ->add('porcentaje', NumberType::class, [
                'label'=>'Porcentaje',
                'scale' => 2,
                'grouping' => true,
                'attr' => ['readonly'=> true, 'class' => 'svtext-right item-porcentaje', 'autocomplete' => 'off']
            ])

            //sv_shara modificado
            ->add('retenido', NumberType::class,['label'=>'Retenido', 'required' => true, 'scale' => 2, 'grouping' => true, 'attr' => ['readonly'=> true, 'class' => 'svtext-right item-retenido', 'autocomplete' => 'off']])

        ;

        $builder->add('tipoRetencion', EntityType::class, ['class' => \App\Entity\Model\TipoRetencion::class, 'choice_label' => static function (TipoRetencion $item, $key, $index) {
            $len =strlen($item->getName());
            $nombre = $item->getName();
            if ($len > 100){
                $nombre = substr($item->getName(),0,100)."...";
            }

            return $item->getCodigo().' - '.$nombre;
        }, 'choice_value' => static function (TipoRetencion $entity = null) {
            return $entity !== null ? $entity->getId() : '';
        }, 'query_builder' => static function (EntityRepository $er) {
            return $er->createQueryBuilder('t')
                ->where('t.enabled = 1')
                ->addOrderBy('t.tipo', 'ASC')
                ->addOrderBy('t.codigo', 'ASC');
        }, 'multiple' => false, 'required' => false, 'attr' => ['autocomplete' => 'off']]);

        /*$builder->get('product')
            ->addModelTransformer(new CallbackTransformer(
                function ($product) {
                    return $product ? $product->getReference() : '';
                },
                function ($reference) {
                    $product = $this->manager
                        ->getRepository('SiwappProductBundle:Product')
                        ->findOneBy(['reference' => $reference]);

                    return $product;
                }
            ))
        ;*/
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \App\Entity\Model\ItemRetencion::class,
        ]);
    }
}
