<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use App\Entity\Model\Retencion;

class SearchRetencionType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('terms', null, [
                'required' => false,
                'label' => 'search.terms',
                'translation_domain' => 'retencion',
            ])
            ->add('status', ChoiceType::class, [
                'label' => 'search.status',
                'translation_domain' => 'retencion',
                'choices' => [
                    'invoice.draft' => Retencion::DRAFT,
                    'invoice.opened' => Retencion::OPENED,
                    'invoice.overdue' => Retencion::OVERDUE,
                    'invoice.closed' => Retencion::CLOSED,
                ],
                'required' => false,
            ])
            ->add('date_from', DateType::class, [
                'label' => 'search.date_from',
                'translation_domain' => 'retencion',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('date_to', DateType::class, [
                'label' => 'search.date_to',
                'translation_domain' => 'retencion',
                'widget' => 'single_text',
                'required' => false,
            ])
            ->add('customer', null, [
                'label' => 'Cliente',
                'translation_domain' => 'retencion',
                'required' => false,
            ])

        ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(['csrf_protection' => false]);
    }
}
