<?php


namespace App\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class AppExtension extends AbstractExtension
{
    public function getFilters(): array
    {
        return [
            new TwigFilter('localizedcurrency', function ($number, $currency, $locale, $decimals = 2) {
                return $this->formatPrice($number, $currency, $locale, $decimals);
            }),
        ];
    }

    /*public function formatPrice($number, $decimals = 0, $decPoint = '.', $thousandsSep = ',')
    {
        $price = number_format($number, $decimals, $decPoint, $thousandsSep);
        $price = '$'.$price;

        return $price;
    }
    */

    public function formatPrice($number, $currency, $locale, $decimals = 2)
    {
        //$price = number_format($number, $decimals, $decPoint, $thousandsSep);
        if ($currency === 'USD')
            $currency = "$";

        $number = number_format($number, $decimals);

        return $currency . '' . $number;
    }
}
